package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the RECIPE table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="RECIPE"
 */

public abstract class BaseRecepie  implements Comparable, Serializable {

	public static String REF = "Recepie"; //$NON-NLS-1$
	public static String PROP_YIELD_UNIT = "yieldUnit"; //$NON-NLS-1$
	public static String PROP_DESCRIPTION = "description"; //$NON-NLS-1$
	public static String PROP_BATCH_PROCESS = "batchProcess"; //$NON-NLS-1$
	public static String PROP_MENU_ITEM = "menuItem"; //$NON-NLS-1$
	public static String PROP_PORTION_UNIT = "portionUnit"; //$NON-NLS-1$
	public static String PROP_LABOR_COST = "laborCost"; //$NON-NLS-1$
	public static String PROP_CODE = "code"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_COOKING_TIME = "cookingTime"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_ADJUSTMENT_AMOUNT = "adjustmentAmount"; //$NON-NLS-1$
	public static String PROP_YIELD = "yield"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_PORTION = "portion"; //$NON-NLS-1$


	// constructors
	public BaseRecepie () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseRecepie (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	/**
	 * Constructor for required fields
	 */
	public BaseRecepie (
		java.lang.String id,
		java.lang.String name) {

		this.setId(id);
		this.setName(name);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String code;
				private java.lang.String name;
				private java.lang.String description;
				private java.lang.Double yield;
				private java.lang.String yieldUnit;
				private java.lang.Double portion;
				private java.lang.String portionUnit;
				private java.lang.Double adjustmentAmount;
				private java.lang.Double laborCost;
				private java.lang.Boolean batchProcess;
				private java.lang.Integer cookingTime;
				private java.lang.Boolean deleted;
	
	// many to one
	private com.floreantpos.model.MenuItem menuItem;

	// collections
	private java.util.List<com.floreantpos.model.RecepieItem> recepieItems;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.NameBaseIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: CODE
	 */

	public java.lang.String getCode () {
			return code;
	}



	/**
	 * Set the value related to the column: CODE
	 * @param code the CODE value
	 */
			public void setCode (java.lang.String code) {
			this.code = code;
	}



	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: DESCRIPTION
	 */

	public java.lang.String getDescription () {
			return description;
	}



	/**
	 * Set the value related to the column: DESCRIPTION
	 * @param description the DESCRIPTION value
	 */
			public void setDescription (java.lang.String description) {
			this.description = description;
	}



	/**
	 * Return the value associated with the column: YIELD
	 */

	public java.lang.Double getYield () {
						return yield == null ? Double.valueOf(0) : yield;
		}



	/**
	 * Set the value related to the column: YIELD
	 * @param yield the YIELD value
	 */
			public void setYield (java.lang.Double yield) {
			this.yield = yield;
	}



	/**
	 * Return the value associated with the column: YIELD_UNIT
	 */

	public java.lang.String getYieldUnit () {
			return yieldUnit;
	}



	/**
	 * Set the value related to the column: YIELD_UNIT
	 * @param yieldUnit the YIELD_UNIT value
	 */
			public void setYieldUnit (java.lang.String yieldUnit) {
			this.yieldUnit = yieldUnit;
	}



	/**
	 * Return the value associated with the column: PORTION
	 */

	public java.lang.Double getPortion () {
						return portion == null ? Double.valueOf(0) : portion;
		}



	/**
	 * Set the value related to the column: PORTION
	 * @param portion the PORTION value
	 */
			public void setPortion (java.lang.Double portion) {
			this.portion = portion;
	}



	/**
	 * Return the value associated with the column: PORTION_UNIT
	 */

	public java.lang.String getPortionUnit () {
			return portionUnit;
	}



	/**
	 * Set the value related to the column: PORTION_UNIT
	 * @param portionUnit the PORTION_UNIT value
	 */
			public void setPortionUnit (java.lang.String portionUnit) {
			this.portionUnit = portionUnit;
	}



	/**
	 * Return the value associated with the column: ADJUSTMENT_AMOUNT
	 */

	public java.lang.Double getAdjustmentAmount () {
						return adjustmentAmount == null ? Double.valueOf(0) : adjustmentAmount;
		}



	/**
	 * Set the value related to the column: ADJUSTMENT_AMOUNT
	 * @param adjustmentAmount the ADJUSTMENT_AMOUNT value
	 */
			public void setAdjustmentAmount (java.lang.Double adjustmentAmount) {
			this.adjustmentAmount = adjustmentAmount;
	}



	/**
	 * Return the value associated with the column: LABOR_COST
	 */

	public java.lang.Double getLaborCost () {
						return laborCost == null ? Double.valueOf(0) : laborCost;
		}



	/**
	 * Set the value related to the column: LABOR_COST
	 * @param laborCost the LABOR_COST value
	 */
			public void setLaborCost (java.lang.Double laborCost) {
			this.laborCost = laborCost;
	}



	/**
	 * Return the value associated with the column: BATCH_PROCESS
	 */

	public java.lang.Boolean isBatchProcess () {
					return batchProcess == null ? Boolean.FALSE : batchProcess;
		}

	public java.lang.Boolean getBatchProcess () {
				return batchProcess == null ? Boolean.FALSE : batchProcess;
			}


	/**
	 * Set the value related to the column: BATCH_PROCESS
	 * @param batchProcess the BATCH_PROCESS value
	 */
			public void setBatchProcess (java.lang.Boolean batchProcess) {
			this.batchProcess = batchProcess;
	}



	/**
	 * Return the value associated with the column: COOKING_TIME
	 */

	public java.lang.Integer getCookingTime () {
						return cookingTime == null ? Integer.valueOf(0) : cookingTime;
		}



	/**
	 * Set the value related to the column: COOKING_TIME
	 * @param cookingTime the COOKING_TIME value
	 */
			public void setCookingTime (java.lang.Integer cookingTime) {
			this.cookingTime = cookingTime;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: MENU_ITEM_ID
	 */

	public com.floreantpos.model.MenuItem getMenuItem () {
			return menuItem;
	}



	/**
	 * Set the value related to the column: MENU_ITEM_ID
	 * @param menuItem the MENU_ITEM_ID value
	 */
			public void setMenuItem (com.floreantpos.model.MenuItem menuItem) {
			this.menuItem = menuItem;
	}



	/**
	 * Return the value associated with the column: recepieItems
	 */

	public java.util.List<com.floreantpos.model.RecepieItem> getRecepieItems () {
			return recepieItems;
	}



	/**
	 * Set the value related to the column: recepieItems
	 * @param recepieItems the recepieItems value
	 */
			public void setRecepieItems (java.util.List<com.floreantpos.model.RecepieItem> recepieItems) {
			this.recepieItems = recepieItems;
	}

	public void addTorecepieItems (com.floreantpos.model.RecepieItem recepieItem) {
		if (null == getRecepieItems()) setRecepieItems(new java.util.ArrayList<com.floreantpos.model.RecepieItem>());
		getRecepieItems().add(recepieItem);
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.Recepie)) return false;
		else {
			com.floreantpos.model.Recepie recepie = (com.floreantpos.model.Recepie) obj;
			if (null == this.getId() || null == recepie.getId()) return this == obj;
			else return (this.getId().equals(recepie.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}