package com.floreantpos.util;

import java.util.Date;

import org.hibernate.Session;

import com.floreantpos.model.SequenceNumber;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.SequenceNumberDAO;

public class OutdoorTicketTokenNumberGenerator {
	public static int generateTokenNo() {
		try (Session session = GenericDAO.getInstance().createNewSession()) {
			String date = SequenceNumber.yearMonthDayFormat.format(new Date());
			
			return SequenceNumberDAO.getInstance().getNextSequenceNumber(SequenceNumber.OUTDOOR_TICKET_TOKEN, date);
		}
	}
}
