package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BaseOrderHistory;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

public class OrderHistory extends BaseOrderHistory implements PropertyContainer2 {
	private static final long serialVersionUID = 1L;
	private transient JsonObject propertiesContainer;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public OrderHistory() {
	}

	/**
	 * Constructor for primary key
	 */
	public OrderHistory(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProprties = super.getProperties();
		if (StringUtils.isEmpty(jsonProprties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProprties, com.google.gson.JsonObject.class);
		}
		return propertiesContainer;
	}

}