package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosException;
import com.floreantpos.model.BloodGroupType;
import com.floreantpos.model.BloodInventory;
import com.floreantpos.model.BloodInventoryTransaction;
import com.floreantpos.swing.PaginatedListModel;

public class BloodInventoryDAO extends BaseBloodInventoryDAO {

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	@Override
	protected void delete(Object obj, Session session) {
		BloodInventory bean = (BloodInventory) obj;
		if (bean == null) {
			throw new PosException("Blood inventory not found!");
		}
		bean.setDeleted(Boolean.TRUE);
		update(bean, session);
	}

	@Override
	public List<BloodInventory> findAll() {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(BloodInventory.class);
			addDeletedFilter(criteria);

			criteria.addOrder(Order.asc(BloodInventory.PROP_CREATE_DATE));
			return criteria.list();
		}
	}

	public void loadBloodInventory(PaginatedListModel<BloodInventory> dataModel, BloodGroupType bloodGroup) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(BloodInventory.class);
			addDeletedFilter(criteria);

			if (bloodGroup != null) {
				criteria.add(Restrictions.le(BloodInventory.PROP_BLOOD_GROUP, bloodGroup.name()));
			}

			dataModel.setNumRows(rowCount(criteria));

			criteria.addOrder(Order.asc(BloodInventory.PROP_TRANSACTION_DATE));
			criteria.setFirstResult(dataModel.getCurrentRowIndex());
			criteria.setMaxResults(dataModel.getPageSize());
			dataModel.setData(criteria.list());
		}
	}

	public BloodInventory getBloodInventoryStock(BloodInventoryTransaction trans, String inventoryToLocation, Session session) {

		Criteria criteria = session.createCriteria(BloodInventory.class);

		//criteria.add(Restrictions.eq(BloodInventory.PROP_STORAGE_LOCATION, inventoryToLocation));
		criteria.add(Restrictions.eq(BloodInventory.PROP_OUTLET_ID, trans.getOutletId()));

		criteria.add(Restrictions.eq(BloodInventory.PROP_BLOOD_GROUP, trans.getBloodGroup()));

		String bloodType = trans.getBloodType();
		if (bloodType == null) {
			criteria.add(Restrictions.isNull(BloodInventory.PROP_BLOOD_TYPE));
		}
		else {
			criteria.add(Restrictions.eq(BloodInventory.PROP_BLOOD_TYPE, bloodType));
		}

		criteria.add(Restrictions.eq(BloodInventory.PROP_UNIT, trans.getUnit()));
		criteria.add(Restrictions.eq(BloodInventory.PROP_VOLUME, trans.getVolume()));

		criteria.addOrder(Order.asc(BloodInventory.PROP_BLOOD_GROUP));

		criteria.setMaxResults(1);// criteria.list()

		return (BloodInventory) criteria.uniqueResult();
	}

}