package com.floreantpos.model.util;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.DurationType;
import com.floreantpos.model.OutdoorDoctorProfile;
import com.floreantpos.model.OutdoorTicket;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Patient;
import com.floreantpos.model.dao.OutdoorTicketDAO;

public class OutdoorTicketBookingUtil {

	public static OutdoorFeeResult calculateOutdoorFee(Double basePrice, Outlet outlet, OutdoorDoctorProfile doctorProfile, Patient patient,
			String currentOutdoorTicketId, boolean applyRevisitCheck) {
		Double outdoorCharge = basePrice;
		OutdoorConfigurationFeeType feeType = outlet.getOutdoorFeeType();
		boolean isFixedFee = OutdoorConfigurationFeeType.FixedOutdoorFee == feeType;

		Integer revisitInterval;
		String durationTypeName;
		String doctorId = null;

		if (isFixedFee) {
			revisitInterval = outlet.getRevisitInterval();
			durationTypeName = outlet.getRevisitDurationType();
		}
		else {
			if (doctorProfile == null) {
				return new OutdoorFeeResult(basePrice, null, null);
			}
			revisitInterval = doctorProfile.getRevisitInterval();
			durationTypeName = doctorProfile.getRevisitDurationType();
			doctorId = doctorProfile.getDoctorId();
		}

		String customerId = patient == null ? "" : patient.getId();
		boolean isApplyRevisitFee = false;
		OutdoorTicket previousVisit = null;

		int revisitDays = DateUtil.getRevisitIntervalInDays(revisitInterval, DurationType.valueOf(durationTypeName));
		previousVisit = OutdoorTicketDAO.getInstance().getPreviousOutdoorVisit(customerId, doctorId, currentOutdoorTicketId, revisitDays);
		if (applyRevisitCheck && StringUtils.isNotBlank(customerId)) {
			isApplyRevisitFee = previousVisit != null;
		}

		if (isApplyRevisitFee) {
			if (isFixedFee) {
				outdoorCharge = outlet.getRevisitFee();
			}
			else if (doctorProfile != null) {
				outdoorCharge = doctorProfile.getRevisitFee();
			}
		}
		else {
			if (isFixedFee) {
				outdoorCharge = outlet.getOutdoorFee();
			}
			else if (doctorProfile != null) {
				outdoorCharge = doctorProfile.getOutdoorFee();
			}
		}

		return new OutdoorFeeResult(outdoorCharge, previousVisit, isApplyRevisitFee);
	}

	public static class OutdoorFeeResult {
		public final double charge;
		public final OutdoorTicket previousVisit;
		public final Boolean isApplyRevisitFee;

		public OutdoorFeeResult(double charge, OutdoorTicket previousVisit, Boolean isApplyRevisitFee) {
			this.charge = charge;
			this.previousVisit = previousVisit;
			this.isApplyRevisitFee = isApplyRevisitFee;
		}
	}
}
