package com.floreantpos.model.util;
public enum ServiceType {
	ANESTHESIA("Anesthesia"),
    ANESTHESIA_GENERAL("General Anesthesia"),
    ANESTHESIA_REGIONAL("Regional Anesthesia"),
    ANESTHESIA_LOCAL("Local Anesthesia"),
    ANESTHESIA_SEDATION("Sedation Anesthesia")
	;

    private final String displayString;

    ServiceType(String displayName) {
        this.displayString = displayName;
    }

    public String getDisplayName() {
        return displayString;
    }

    public static ServiceType fromDisplayName(String name) {
        for (ServiceType type : values()) {
            if (type.displayString.equalsIgnoreCase(name)) {
                return type;
            }
        }
        return null;
    }
    
    @Override
	public String toString() {
		return displayString;
	}
    
    public static boolean match(String serviceTypeName, ServiceType serviceType) {
		ServiceType service = ServiceType.fromDisplayName(serviceTypeName);
		return serviceType == service;
	}

}
