package com.floreantpos.model.ext;

public enum LabWorkStatus {
	//@formatter:off
	PENDING_SAMPLE("Pending sample"), 
	SAMPLE_COLLECTED("Sample collected"), 
	RUN_TEST("Run test"), 
	RESULT_RECORDED("Result recorded"), 
	APPROVED("Approved"),
	DISPATCHED("Dispatched"),
	RE_TEST("Retest"),
	DECLINED("Declined"),
	ONGOINING("Ongoing"),
	READY("Ready"),
	DELIVERED("Delivered")
	; 

	//@formatter:on

	private String labWorkStatusName;

	private LabWorkStatus(String labWorkStatusName) {
		this.labWorkStatusName = labWorkStatusName;
	}

	public static LabWorkStatus fromString(String labWorkStatusName) {
		LabWorkStatus[] statusList = values();
		for (LabWorkStatus labWorkStatus : statusList) {
			if (labWorkStatus.name().equals(labWorkStatusName)) {
				return labWorkStatus;
			}
		}
		return PENDING_SAMPLE;
	}

	public String getValue() {
		return labWorkStatusName;
	}
	
	@Override
	public String toString() {
		return getValue();
	}
}
