package com.floreantpos.report;

import java.io.Serializable;
import java.util.Date;

import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.NumberUtil;

public class UserWiseCollectionReportData implements Serializable {

	private String id;
	private String patientName;
	private double dueColl;
	private double taxAmount;
	private double totalAmount;
	private double advancedAmount;
	private double discount;
	private double vatAmount;
	private String subTotalAmount;
	private String orderId;
	private String orderDate;
	private int serialNumber;

	public UserWiseCollectionReportData() {
	}

	public UserWiseCollectionReportData(PosTransaction transaction, int serialNumber) {
		Ticket ticket = transaction.getTicket();
		setSerialNumber(serialNumber);
		setOrderId(ticket.getId());
		setOrderDate(DateUtil.formatAsShortDate(DateUtil.convertServerTimeToBrowserTime((ticket.getCreateDate()))));
		setPatientName(ticket.getCustomerName());
		setSubTotalAmount(NumberUtil.formatAmount(ticket.getSubtotalAmount()));
		setVatAmount(ticket.getTaxAmount());
		setDiscount(ticket.getDiscountAmount());
		setTotalAmount(ticket.getTotalAmount());
		calculateAmount(transaction, ticket);
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getPatientName() {
		return patientName;
	}

	public void setPatientName(String patientName) {
		this.patientName = patientName;
	}

	public double getDueColl() {
		return dueColl;
	}

	public void setDueColl(double dueColl) {
		this.dueColl = dueColl;
	}

	public double getTaxAmount() {
		return taxAmount;
	}

	public void setTaxAmount(double taxAmount) {
		this.taxAmount = taxAmount;
	}

	public double getTotalAmount() {
		return totalAmount;
	}

	public void setTotalAmount(double totalAmount) {
		this.totalAmount = totalAmount;
	}

	public double getAdvancedAmount() {
		return advancedAmount;
	}

	public void setAdvancedAmount(double advancedAmount) {
		this.advancedAmount = advancedAmount;
	}

	public String getSubTotalAmount() {
		return subTotalAmount;
	}

	public void setSubTotalAmount(String subTotalAmount) {
		this.subTotalAmount = subTotalAmount;
	}

	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public String getOrderDate() {
		return orderDate;
	}

	public void setOrderDate(String orderDate) {
		this.orderDate = orderDate;
	}

	public double getDiscount() {
		return discount;
	}

	public void setDiscount(double discount) {
		this.discount = discount;
	}

	public int getSerialNumber() {
		return serialNumber;
	}

	public void setSerialNumber(int serialNumber) {
		this.serialNumber = serialNumber;
	}

	public void calculateAmount(PosTransaction posTransaction, Ticket ticket) {
		Date tDate = ticket.getCreateDate();
		if (!posTransaction.isVoided()) {
			Date startOfDay = DateUtil.startOfDay(posTransaction.getTransactionTime());
			if (tDate.before(startOfDay)) {
				double dueCollectionAmount = 0;
				if (posTransaction instanceof RefundTransaction) {
					dueCollectionAmount += (-1) * posTransaction.getAmount();
				}
				else {
					dueCollectionAmount += posTransaction.getAmount();
				}
				setDueColl(dueCollectionAmount);
			}
			else {
				double advancedAmount = 0;
				if (posTransaction instanceof RefundTransaction) {
					advancedAmount += (-1) * posTransaction.getAmount();
				}
				else {
					advancedAmount += posTransaction.getAmount();
				}
				setAdvancedAmount(advancedAmount);
			}
		}
	}

	public double getVatAmount() {
		return vatAmount;
	}

	public void setVatAmount(double vatAmount) {
		this.vatAmount = vatAmount;
	}
}
