package com.floreantpos.report.model;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.POSConstants;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.InventoryUnitConvertionUtil;
import com.floreantpos.swing.ListTableModel;

public class InventoryAverageCostUnitReportModel extends ListTableModel {
	SimpleDateFormat dateFormat2 = new SimpleDateFormat("MMM-dd-yy HH:mm "); //$NON-NLS-1$

	DecimalFormat decimalFormat = new DecimalFormat("0.00"); //$NON-NLS-1$
	private double totalAmount;
	private double totalQuantity;
	double totalOnHandValue, amount;
	String type;

	private Double unitCost;
	private boolean showOnlyItemUnit = false;

	public InventoryAverageCostUnitReportModel() {
		super(new String[] { "itemgroup", "items", "sku", "date", "vendor", "reasonType", "openingQty", "openingCost", "openingTotalCost", "quantity", "unit", //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$//$NON-NLS-5$//$NON-NLS-6$//$NON-NLS-7$//$NON-NLS-8$//$NON-NLS-9$//$NON-NLS-10$//$NON-NLS-11$
				"cost", "total", "itemBaseUnitQuantity", "itemBaseUnitCost", "itemBaseUnitTotalCost", "itemBaseUnit" }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
	}

	public void setItems(List<InventoryTransaction> transactions, boolean showOnlyItemUnit) {
		this.showOnlyItemUnit = showOnlyItemUnit;
		setRows(transactions);
		totalAmount = 0;
		for (InventoryTransaction item : transactions) {
			totalAmount += item.getTotal();
		}
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		InventoryTransaction transactionData = (InventoryTransaction) rows.get(rowIndex);
		MenuItem menuItem = transactionData.getMenuItem();
		switch (columnIndex) {
			case 0:
				return StringUtils.isBlank(menuItem.getMenuGroupName()) ? POSConstants.NONE : menuItem.getMenuGroupName();

			case 1:
				return menuItem.getDisplayName();

			case 2:
				return menuItem.getSku();

			case 3:
				return dateFormat2.format(transactionData.getTransactionDate());
			case 4:
				InventoryVendor vendor = transactionData.getVendor();
				return vendor == null || StringUtils.isBlank(vendor.getName()) ? "" : vendor.getName(); //$NON-NLS-1$
			case 5:
				return transactionData.getReason().toString();

			case 6:
				return transactionData.getOpeningQty();

			case 7:
				return transactionData.getOpeningCost();

			case 8:
				return transactionData.getOpeningTotalCost();

			case 9:
				if (!showOnlyItemUnit) {
					totalQuantity = transactionData.getQuantity();
				}
				else {
					totalQuantity = menuItem.getBaseUnitQuantity(transactionData.getUnit()) * transactionData.getQuantity();
				}
				return totalQuantity;
			case 10:
				if (!showOnlyItemUnit) {
					return transactionData.getUnitName();
				}
				return transactionData.getMenuItem().getUnit() == null ? "" : transactionData.getMenuItem().getUnit().getUniqueCode(); //$NON-NLS-1$

			case 11:
				if (!showOnlyItemUnit) {
					unitCost = transactionData.getUnitCost();
				}
				else {
					IUnit sourceInventoryUnit = DataProvider.get().getUnitByCode(transactionData.getUnit());
					unitCost = InventoryUnitConvertionUtil.calculateCost(transactionData.getUnitCost(), sourceInventoryUnit, menuItem.getUnit(), menuItem);
				}
				return unitCost;

			case 12:
				return transactionData.getQuantity() * transactionData.getUnitCost();

			case 13:
				totalQuantity = menuItem.getBaseUnitQuantity(transactionData.getUnit()) * transactionData.getQuantity();
				return totalQuantity;

			case 14:
				IUnit sourceUnit = DataProvider.get().getUnitByCode(transactionData.getUnit());
				unitCost = InventoryUnitConvertionUtil.calculateCost(transactionData.getUnitCost(), sourceUnit, menuItem.getUnit(), menuItem);
				return unitCost;

			case 15:
				return totalQuantity * unitCost;

			case 16:
				return transactionData.getMenuItem().getUnit() == null ? "" : transactionData.getMenuItem().getUnit().getCode(); //$NON-NLS-1$
		}
		return null;
	}

	public double getTotalAmount() {
		return totalAmount;
	}

	public double getTotalQuantity() {
		return totalQuantity;
	}

	public void setQuantity(List<InventoryTransaction> transactions) {
		setRows(transactions);
		totalQuantity = 0;
		for (InventoryTransaction item : transactions) {

			if (item.getType().equals(InventoryTransactionType.IN.getType())) {
				totalQuantity += item.getQuantity();
			}
			else if (item.getType().equals(InventoryTransactionType.OUT.getType())) {
				totalQuantity -= item.getQuantity();
			}
		}
	}
}