package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosLog;
import com.floreantpos.model.ReportGroup;
import com.floreantpos.swing.PaginationSupport;
import com.orocube.rest.service.server.BaseDataServiceDao;

public class ReportGroupDAO extends BaseReportGroupDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public ReportGroupDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	public void saveOrUpdateReportGroup(List<ReportGroup> reportGroupList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
		if (reportGroupList == null)
			return;

		Transaction tx = null;
		try (Session session = createNewSession()) {
			tx = session.beginTransaction();
			for (Iterator<ReportGroup> iterator = reportGroupList.iterator(); iterator.hasNext();) {
				ReportGroup item = (ReportGroup) iterator.next();
				ReportGroup existingItem = get(item.getId());
				if (existingItem != null) {
					if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
						PosLog.info(getClass(), item.getName() + " already updated"); //$NON-NLS-1$
						continue;
					}
					long version = existingItem.getVersion();
					PropertyUtils.copyProperties(existingItem, item);
					existingItem.setVersion(version);
					existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
					existingItem.setUpdateSyncTime(updateSyncTime);
					update(existingItem);
				}
				else {
					item.setVersion(0);
					item.setUpdateLastUpdateTime(updateLastUpdateTime);
					item.setUpdateSyncTime(updateSyncTime);
					save(item);
				}
			}
			tx.commit();
		} catch (Exception e) {
			tx.rollback();
			throw e;
		}
	}

	public void findByName(String reportGroupName, PaginationSupport paginationSupport) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(ReportGroup.class);
			addDeletedFilter(criteria);

			if (StringUtils.isNotBlank(reportGroupName)) {
				criteria.add(Restrictions.eq(ReportGroup.PROP_NAME, reportGroupName).ignoreCase());
			}

			paginationSupport.setNumRows(rowCount(criteria));
			criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
			criteria.setMaxResults(paginationSupport.getPageSize());
			criteria.addOrder(Order.asc(ReportGroup.PROP_NAME).ignoreCase());
			paginationSupport.setRows(criteria.list());

		}
	}

}