package com.floreantpos.model.util;

import java.io.Serializable;
import java.util.List;

import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.ProductType;

public class MenuSearchCriteria implements Serializable {
	private Boolean inventoryItemOnly;
	private MenuGroup menuGroup;
	private MenuCategory menuCategory;
	private String itemNameOrBarcode;
	private Boolean includeVariantParent;
	private Boolean pizzaType;
	private boolean showVariant;
	private boolean showComboItem;
	private MenuItem currentMenuItem;
	private Boolean activeStatus;
	private Boolean showOnlineItem;
	private Boolean isService;
	private List<ProductType> productType;

	/**
	 * @param inventoryItemOnly
	 * @param menuGroup
	 * @param itemNameOrBarcode
	 * @param includeVariantParent
	 * @param pizzaType
	 * @param showVariant
	 * @param showComboItem
	 */
	public MenuSearchCriteria(Boolean inventoryItemOnly, MenuGroup menuGroup, String itemNameOrBarcode, Boolean includeVariantParent, Boolean pizzaType,
			boolean showVariant, boolean showComboItem) {
		this(inventoryItemOnly, menuGroup, itemNameOrBarcode, includeVariantParent, pizzaType, showVariant, showComboItem, null);
	}

	/**
	 * @param inventoryItemOnly
	 * @param menuGroup
	 * @param itemNameOrBarcode
	 * @param includeVariantParent
	 * @param pizzaType
	 * @param showVariant
	 * @param showComboItem
	 * @param currentMenuItem
	 */
	public MenuSearchCriteria(Boolean inventoryItemOnly, MenuGroup menuGroup, String itemNameOrBarcode, Boolean includeVariantParent, Boolean pizzaType,
			boolean showVariant, boolean showComboItem, MenuItem currentMenuItem) {
		super();
		this.inventoryItemOnly = inventoryItemOnly;
		this.menuGroup = menuGroup;
		this.itemNameOrBarcode = itemNameOrBarcode;
		this.includeVariantParent = includeVariantParent;
		this.pizzaType = pizzaType;
		this.showVariant = showVariant;
		this.showComboItem = showComboItem;
		this.currentMenuItem = currentMenuItem;
	}

	/**
	 * @param inventoryItemOnly
	 * @param menuCategory
	 * @param menuGroup
	 * @param itemNameOrBarcode
	 * @param includeVariantParent
	 * @param pizzaType
	 * @param showInvisibleItems
	 * @param showVariant
	 * @param showComboItem
	 * @param currentMenuItem
	 */
	public MenuSearchCriteria(Boolean inventoryItemOnly, MenuCategory menuCategory, MenuGroup menuGroup, String itemNameOrBarcode, Boolean includeVariantParent,
			Boolean pizzaType, boolean showVariant, boolean showComboItem, MenuItem currentMenuItem) {
		super();
		this.inventoryItemOnly = inventoryItemOnly;
		this.menuCategory = menuCategory;
		this.menuGroup = menuGroup;
		this.itemNameOrBarcode = itemNameOrBarcode;
		this.includeVariantParent = includeVariantParent;
		this.pizzaType = pizzaType;
		this.showVariant = showVariant;
		this.showComboItem = showComboItem;
		this.currentMenuItem = currentMenuItem;

	}

	public Boolean getInventoryItemOnly() {
		return inventoryItemOnly;
	}

	public void setInventoryItemOnly(Boolean inventoryItemOnly) {
		this.inventoryItemOnly = inventoryItemOnly;
	}

	public MenuGroup getMenuGroup() {
		return menuGroup;
	}

	public void setMenuGroup(MenuGroup menuGroup) {
		this.menuGroup = menuGroup;
	}

	public String getItemNameOrBarcode() {
		return itemNameOrBarcode;
	}

	public void setItemNameOrBarcode(String itemNameOrBarcode) {
		this.itemNameOrBarcode = itemNameOrBarcode;
	}

	public Boolean getIncludeVariantParent() {
		return includeVariantParent;
	}

	public void setIncludeVariantParent(Boolean includeVariantParent) {
		this.includeVariantParent = includeVariantParent;
	}

	public Boolean getPizzaType() {
		return pizzaType;
	}

	public void setPizzaType(Boolean pizzaType) {
		this.pizzaType = pizzaType;
	}

	public boolean isShowVariant() {
		return showVariant;
	}

	public void setShowVariant(boolean showVariant) {
		this.showVariant = showVariant;
	}

	public boolean isShowComboItem() {
		return showComboItem;
	}

	public void setShowComboItem(boolean showComboItem) {
		this.showComboItem = showComboItem;
	}

	public MenuItem getCurrentMenuItem() {
		return currentMenuItem;
	}

	public void setCurrentMenuItem(MenuItem currentMenuItem) {
		this.currentMenuItem = currentMenuItem;
	}

	public MenuCategory getMenuCategory() {
		return menuCategory;
	}

	public void setMenuCategory(MenuCategory menuCategory) {
		this.menuCategory = menuCategory;
	}

	public Boolean isShowOnlineItem() {
		return showOnlineItem;
	}

	public void setShowOnlineItem(Boolean showOnlineItem) {
		this.showOnlineItem = showOnlineItem;
	}

	public Boolean getActiveStatus() {
		return activeStatus;
	}

	public void setActiveStatus(Boolean activeStatus) {
		this.activeStatus = activeStatus;
	}

	public Boolean isServiceStatus() {
		return isService;
	}

	public void setServiceStatus(Boolean isService) {
		this.isService = isService;
	}

	public List<ProductType> getProductType() {
		return productType;
	}

	public void setProductType(List<ProductType> productType) {
		this.productType = productType;
	}

}
