package com.floreantpos.model;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseOutdoorDoctorProfile;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.OrgJsonUtil;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown = true)
public class OutdoorDoctorProfile extends BaseOutdoorDoctorProfile implements TimedModel, PropertyContainer2 {
	private static final long serialVersionUID = 1L;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	private transient JsonObject propertiesContainer;

	private transient Doctor outdoorDoctor;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public OutdoorDoctorProfile() {
	}

	/**
	 * Constructor for primary key
	 */
	public OutdoorDoctorProfile(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	@Override
	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	@Override
	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	@Override
	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProperties = super.getProperties();
		if (StringUtils.isEmpty(jsonProperties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProperties, JsonObject.class);
		}
		return propertiesContainer;
	}

	@Override
	public String toString() {
		return getDoctorName();
	}

	@XmlTransient
	@JsonIgnore
	public Doctor getOutdoorDoctor() {
		if (outdoorDoctor != null) {
			return outdoorDoctor;
		}

		String doctorId = getDoctorId();
		if (StringUtils.isNotBlank(doctorId)) {
			outdoorDoctor = (Doctor) DataProvider.get().getObjectOf(Doctor.class, doctorId);
		}
		else {
			outdoorDoctor = null;
		}

		return outdoorDoctor;

	}

	@XmlTransient
	@JsonIgnore
	public List<DoctorTimeSchedule> getSchedules() {
		List<DoctorTimeSchedule> dataList = new ArrayList<>();
		JsonObject jsonProperties = getPropertyStore();
		if (jsonProperties == null || !jsonProperties.has("appointmentTimes")) { //$NON-NLS-1$
			return dataList;
		}
		JsonArray jsonArray = jsonProperties.getAsJsonArray("appointmentTimes"); //$NON-NLS-1$
		for (int i = 0; i < jsonArray.size(); i++) {
			JsonObject jsonObject = jsonArray.get(i).getAsJsonObject();
			DoctorTimeSchedule data = new DoctorTimeSchedule();
			data.setShiftName(OrgJsonUtil.getString(jsonObject, DoctorTimeSchedule.PROP_SHIFT_NAME));
			data.setStartTime(OrgJsonUtil.getString(jsonObject, DoctorTimeSchedule.PROP_START_TIME));
			data.setEndTime(OrgJsonUtil.getString(jsonObject, DoctorTimeSchedule.PROP_END_TIME));
			data.setConsultationTime(OrgJsonUtil.getInt(jsonObject, DoctorTimeSchedule.PROP_CONSULTATION_TIME));
			data.setConsultationFees(OrgJsonUtil.getDouble(jsonObject, DoctorTimeSchedule.PROP_CONSULTATION_FEES));
			data.setPatientCount(OrgJsonUtil.getInt(jsonObject, DoctorTimeSchedule.PROP_PATIENT_COUNT));
			data.setOutdoorFee(OrgJsonUtil.getDouble(jsonObject, "outdoorFee")); //$NON-NLS-1$
			data.setRevisitFee(OrgJsonUtil.getDouble(jsonObject, "revisitFee")); //$NON-NLS-1$
			data.setDoctorChargeRate(OrgJsonUtil.getDouble(jsonObject, "doctorChargeRate")); //$NON-NLS-1$
			data.setDoctorChargeType(OrgJsonUtil.getString(jsonObject, "doctorChargeType")); //$NON-NLS-1$
			data.setRevisitInterval(OrgJsonUtil.getInt(jsonObject, "revisitInterval")); //$NON-NLS-1$
			data.setRevisitDurationType(OrgJsonUtil.getString(jsonObject, "revisitDurationType")); //$NON-NLS-1$
			data.setActive(OrgJsonUtil.getBoolean(jsonObject, "active")); //$NON-NLS-1$
			data.setDefaultShift(OrgJsonUtil.getBoolean(jsonObject, "defaultShift")); //$NON-NLS-1$

			data.setId(OrgJsonUtil.getString(jsonObject, DoctorTimeSchedule.PROP_ID));
			data.setDoctorId(this.getDoctorId());
			List<Integer> days = new ArrayList<>();
			JsonArray daysArray = jsonObject.has("days") ? jsonObject.get("days").getAsJsonArray() : null; //$NON-NLS-1$ //$NON-NLS-2$
			for (int j = 0; j < daysArray.size(); j++) {
				days.add(daysArray.get(j).getAsInt());
			}
			data.setDays(days);
			dataList.add(data);
		}
		return dataList;
	}

	public void setSchedules(List<DoctorTimeSchedule> dataList) {
		if (dataList == null) {
			dataList = new ArrayList<>();
		}
		JsonArray dataArray = new JsonArray();
		for (DoctorTimeSchedule data : dataList) {
			JsonObject jsonObject = new JsonObject();
			jsonObject.addProperty(DoctorTimeSchedule.PROP_CONSULTATION_TIME, data.getConsultationTime());
			jsonObject.addProperty(DoctorTimeSchedule.PROP_CONSULTATION_FEES, data.getConsultationFees());
			jsonObject.addProperty(DoctorTimeSchedule.PROP_PATIENT_COUNT, data.getPatientCount());

			JsonArray daysArray = new JsonArray();
			List<Integer> days = data.getDays();
			if (days == null) {
				days = new ArrayList<>();
			}
			for (Integer day : days) {
				daysArray.add(day);
			}
			jsonObject.add(DoctorTimeSchedule.PROP_DAYS, daysArray);
			jsonObject.addProperty(DoctorTimeSchedule.PROP_END_TIME, data.getEndTime());
			jsonObject.addProperty(DoctorTimeSchedule.PROP_START_TIME, data.getStartTime());
			jsonObject.addProperty(DoctorTimeSchedule.PROP_SHIFT_NAME, data.getShiftName());
			jsonObject.addProperty("outdoorFee", data.getOutdoorFee()); //$NON-NLS-1$
			jsonObject.addProperty("revisitFee", data.getRevisitFee()); //$NON-NLS-1$
			jsonObject.addProperty("doctorChargeRate", data.getDoctorChargeRate()); //$NON-NLS-1$
			jsonObject.addProperty("doctorChargeType", data.getDoctorChargeType()); //$NON-NLS-1$
			jsonObject.addProperty("revisitInterval", data.getRevisitInterval()); //$NON-NLS-1$
			jsonObject.addProperty("revisitDurationType", data.getRevisitDurationType()); //$NON-NLS-1$
			jsonObject.addProperty("active", data.getActive()); //$NON-NLS-1$
			jsonObject.addProperty("defaultShift", data.isDefaultShift()); //$NON-NLS-1$

			jsonObject.addProperty(DoctorTimeSchedule.PROP_ID, data.getId());
			dataArray.add(jsonObject);
		}
		addJsonArray("appointmentTimes", dataArray); //$NON-NLS-1$
		putHasSchedule(dataArray.size() > 0);
	}

	public void putHasSchedule(boolean hasSchedule) {
		addProperty("hasSchedule", String.valueOf(hasSchedule)); //$NON-NLS-1$
	}

	public boolean isHasSchedule() {
		return POSUtil.getBoolean("hasSchedule", false); //$NON-NLS-1$
	}

	public DoctorTimeSchedule getDefaultShift() {
		List<DoctorTimeSchedule> schedules = getSchedules();
		if (schedules != null) {
			for (DoctorTimeSchedule doctorTimeSchedule : schedules) {
				if (doctorTimeSchedule.isDefaultShift()) {
					return doctorTimeSchedule;
				}
			}
		}
		return null;
	}

	public DoctorTimeSchedule getSchedule(String shiftId) {
		if (StringUtils.isBlank(shiftId)) {
			return null;
		}
		List<DoctorTimeSchedule> schedules = getSchedules();
		if (schedules == null) {
			return null;
		}
		for (DoctorTimeSchedule doctorTimeSchedule : schedules) {
			if (doctorTimeSchedule.getId() != null && doctorTimeSchedule.getId().equals(shiftId)) {
				return doctorTimeSchedule;
			}
		}
		return null;
	}

}