package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the NOTIFICATION table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="NOTIFICATION"
 */

public abstract class BaseNotification  implements Comparable, Serializable {

	public static String REF = "Notification"; //$NON-NLS-1$
	public static String PROP_STATUS = "status"; //$NON-NLS-1$
	public static String PROP_UNREAD = "unread"; //$NON-NLS-1$
	public static String PROP_EVENT_TYPE = "eventType"; //$NON-NLS-1$
	public static String PROP_CUSTOMER_ID = "customerId"; //$NON-NLS-1$
	public static String PROP_INVOICE_ID = "invoiceId"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_EVENT_DATA = "eventData"; //$NON-NLS-1$
	public static String PROP_FAILURE_MESSAGE = "failureMessage"; //$NON-NLS-1$
	public static String PROP_SUBSCRIPTION_ID = "subscriptionId"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_CUSTOMER_EMAIL = "customerEmail"; //$NON-NLS-1$
	public static String PROP_CREATED_DATE = "createdDate"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$


	// constructors
	public BaseNotification () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseNotification (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.util.Date createdDate;
				private java.lang.String customerId;
				private java.lang.String customerEmail;
				private java.lang.String subscriptionId;
				private java.lang.String invoiceId;
				private java.lang.String status;
				private java.lang.String eventType;
				private java.lang.String eventData;
				private java.lang.String failureMessage;
				private java.lang.String properties;
				private java.lang.Boolean unread;
				private java.lang.Boolean deleted;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.UUIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: CREATED_DATE
	 */

	public java.util.Date getCreatedDate () {
			return createdDate;
	}



	/**
	 * Set the value related to the column: CREATED_DATE
	 * @param createdDate the CREATED_DATE value
	 */
			public void setCreatedDate (java.util.Date createdDate) {
			this.createdDate = createdDate;
	}



	/**
	 * Return the value associated with the column: CUSTOMER_ID
	 */

	public java.lang.String getCustomerId () {
			return customerId;
	}



	/**
	 * Set the value related to the column: CUSTOMER_ID
	 * @param customerId the CUSTOMER_ID value
	 */
			public void setCustomerId (java.lang.String customerId) {
			this.customerId = customerId;
	}



	/**
	 * Return the value associated with the column: CUSTOMER_EMAIL
	 */

	public java.lang.String getCustomerEmail () {
			return customerEmail;
	}



	/**
	 * Set the value related to the column: CUSTOMER_EMAIL
	 * @param customerEmail the CUSTOMER_EMAIL value
	 */
			public void setCustomerEmail (java.lang.String customerEmail) {
			this.customerEmail = customerEmail;
	}



	/**
	 * Return the value associated with the column: SUBSCRIPTION_ID
	 */

	public java.lang.String getSubscriptionId () {
			return subscriptionId;
	}



	/**
	 * Set the value related to the column: SUBSCRIPTION_ID
	 * @param subscriptionId the SUBSCRIPTION_ID value
	 */
			public void setSubscriptionId (java.lang.String subscriptionId) {
			this.subscriptionId = subscriptionId;
	}



	/**
	 * Return the value associated with the column: INVOICE_ID
	 */

	public java.lang.String getInvoiceId () {
			return invoiceId;
	}



	/**
	 * Set the value related to the column: INVOICE_ID
	 * @param invoiceId the INVOICE_ID value
	 */
			public void setInvoiceId (java.lang.String invoiceId) {
			this.invoiceId = invoiceId;
	}



	/**
	 * Return the value associated with the column: STATUS
	 */

	public java.lang.String getStatus () {
			return status;
	}



	/**
	 * Set the value related to the column: STATUS
	 * @param status the STATUS value
	 */
			public void setStatus (java.lang.String status) {
			this.status = status;
	}



	/**
	 * Return the value associated with the column: EVENT_TYPE
	 */

	public java.lang.String getEventType () {
			return eventType;
	}



	/**
	 * Set the value related to the column: EVENT_TYPE
	 * @param eventType the EVENT_TYPE value
	 */
			public void setEventType (java.lang.String eventType) {
			this.eventType = eventType;
	}



	/**
	 * Return the value associated with the column: EVENT_DATA
	 */

	public java.lang.String getEventData () {
			return eventData;
	}



	/**
	 * Set the value related to the column: EVENT_DATA
	 * @param eventData the EVENT_DATA value
	 */
			public void setEventData (java.lang.String eventData) {
			this.eventData = eventData;
	}

	/**
	 * Return the value associated with the column: FAILURE_MESSAGE
	 */

	public java.lang.String getFailureMessage () {
			return failureMessage;
	}



	/**
	 * Set the value related to the column: FAILURE_MESSAGE
	 * @param failureMessage the FAILURE_MESSAGE value
	 */
			public void setFailureMessage (java.lang.String failureMessage) {
			this.failureMessage = failureMessage;
	}

	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: UNREAD
	 */

	public java.lang.Boolean isUnread () {
						return unread == null ? Boolean.valueOf(true) : unread;
			}

	public java.lang.Boolean getUnread () {
					return unread == null ? Boolean.valueOf(true) : unread;
			}


	/**
	 * Set the value related to the column: UNREAD
	 * @param unread the UNREAD value
	 */
			public void setUnread (java.lang.Boolean unread) {
			this.unread = unread;
	}


	/**
	 * Custom property
	 */
	public static String getUnreadDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.Notification)) return false;
		else {
			com.floreantpos.model.Notification notification = (com.floreantpos.model.Notification) obj;
			if (null == this.getId() || null == notification.getId()) return this == obj;
			else return (this.getId().equals(notification.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}