/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.view.JasperViewer;

import com.floreantpos.Messages;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;

public class ShiftwiseSalesSummaryReportModel extends ListTableModel {

	public ShiftwiseSalesSummaryReportModel(List<ShiftwiseSalesSummaryData> dataList) {
		super(new String[] { "shiftName", "categoryName", "count", "gross", "discount", "netSales", "taxAmount" }, //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$//$NON-NLS-5$//$NON-NLS-6$//$NON-NLS-7$//$NON-NLS-8$//$NON-NLS-9$//$NON-NLS-10$
				dataList);
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		ShiftwiseSalesSummaryData data = (ShiftwiseSalesSummaryData) rows.get(rowIndex);

		switch (columnIndex) {
			case 0:
				return Messages.getString("ShiftwiseSalesSummaryReportModel.0") + data.shiftName; //$NON-NLS-1$

			case 1:
				return data.categoryName;

			case 2:
				return NumberUtil.formatNumber(data.count);

			case 3:
				return NumberUtil.formatNumber(data.gross);

			case 4:
				return NumberUtil.formatNumber(data.discount);
			case 5:
				return NumberUtil.formatNumber(data.netSales);
			case 6:
				return NumberUtil.formatNumber(data.taxAmount);
		}

		return null;
	}

	public static class ShiftwiseSalesSummaryData {
		private String shiftName;
		private String categoryName;
		private double count;
		private double gross;
		private double discount;
		private double netSales;
		private double taxAmount;

		public String getCategoryName() {
			return categoryName;
		}

		public void setCategoryName(String categoryName) {
			this.categoryName = categoryName;
		}

		public double getCount() {
			return count;
		}

		public void setCount(double count) {
			this.count = count;
		}

		public double getDiscount() {
			return discount;
		}

		public void setDiscount(double discount) {
			this.discount = discount;
		}

		public double getGross() {
			return gross;
		}

		public void setGross(double gross) {
			this.gross = gross;
		}

		public double getNetSales() {
			return netSales;
		}

		public void setNetSales(double netSales) {
			this.netSales = netSales;
		}

		public String getShiftName() {
			return shiftName;
		}

		public void setShiftName(String shiftName) {
			this.shiftName = shiftName;
		}

		public double getTaxAmount() {
			return taxAmount;
		}

		public void setTaxAmount(double taxAmount) {
			this.taxAmount = taxAmount;
		}
	}

	public static void main(String[] args) throws Exception {
		ArrayList list = new ArrayList();

		ShiftwiseSalesSummaryData data = new ShiftwiseSalesSummaryData();
		data.setShiftName("SHIFT1"); //$NON-NLS-1$
		data.setCategoryName("C"); //$NON-NLS-1$
		list.add(data);

		data = new ShiftwiseSalesSummaryData();
		data.setShiftName("SHIFT1"); //$NON-NLS-1$
		data.setCategoryName("C2"); //$NON-NLS-1$
		list.add(data);

		data = new ShiftwiseSalesSummaryData();
		data.setShiftName("SHIFT2"); //$NON-NLS-1$
		data.setCategoryName("C"); //$NON-NLS-1$
		list.add(data);

		JasperReport report = ReportUtil.getReport("sales_summary_report2"); //$NON-NLS-1$
		JasperPrint print = JasperFillManager.fillReport(report, new HashMap(), new JRBeanCollectionDataSource(list));

		JasperViewer.viewReport(print, true);
	}
}
