package com.floreantpos.model;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseTestItem;
import com.floreantpos.model.util.DataProvider;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown = true)
public class TestItem extends BaseTestItem implements PropertyContainer, TimedModel {
	//public static final String JESON_PROP_VISIBLE = "visible";
	private static final long serialVersionUID = 1L;
	private transient JsonObject propertiesContainer;
	private transient TicketItem ticketItem;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public TestItem() {
	}

	/**
	 * Constructor for primary key
	 */
	public TestItem(java.lang.String id) {
		super(id);
	}

	/**
	 * Constructor for required fields
	 */
	public TestItem(java.lang.String id, java.lang.String name) {

		super(id, name);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public String toString() {
		return getName();
	}

	public void putTicketItem(TicketItem ticketItem) {
		this.ticketItem = ticketItem;
	}

	public TicketItem getTicketItem() {
		return ticketItem;

	}

	@Override
	public String getProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		propertiesContainer = null;
	}

	@Override
	public void addProperty(String key, String value) {
		initPropertyContainer();
		propertiesContainer.addProperty(key, value);
		super.setProperties(propertiesContainer.toString());
	}

	private void initPropertyContainer() {
		if (propertiesContainer == null) {
			if (StringUtils.isBlank(super.getProperties())) {
				propertiesContainer = new com.google.gson.JsonObject();
			}
			else {
				propertiesContainer = new Gson().fromJson(super.getProperties(), com.google.gson.JsonObject.class);
			}
		}
	}

	@Override
	public com.google.gson.JsonObject getPropertyStore() {
		initPropertyContainer();
		return propertiesContainer;
	}

	public void putInternalNote(String internalNote) {
		addProperty("internal.note", internalNote); //$NON-NLS-1$
	}

	public String getInternalNote() {
		return getProperty("internal.note", ""); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public String getUnitName() {
		String unitId = getUnit();
		if (StringUtils.isBlank(unitId)) {
			return ""; //$NON-NLS-1$
		}
		InventoryUnit inventoryUnit = DataProvider.get().getInventoryUnitById(unitId);
		if (inventoryUnit != null) {
			return inventoryUnit.getName();
		}
		return unitId;
	}

	public String getUnitNameForReportDisplay() {
		String unitName = getUnitName();
		if (StringUtils.isNotBlank(unitName)) {
			return unitName.replaceAll("µ", "µ &nbsp;"); //$NON-NLS-1$//$NON-NLS-2$
		}
		return ""; //$NON-NLS-1$
	}

	public void putTestItemGroup(TestItemGroup testItemGroup) {
		if (testItemGroup != null) {
			setTestItemGroupId(testItemGroup.getId());
			setTestItemGroupName(testItemGroup.getName());
		}
		else {
			setTestItemGroupId(null);
			setTestItemGroupName(null);
		}
	}

	public String getTestItemGroupNameDisplay() {
		String testItemGroupName = getTestItemGroupName();
		if (StringUtils.isNotBlank(testItemGroupName)) {
			return testItemGroupName;
		}

		String testItemGroupId = getTestItemGroupId();
		if (StringUtils.isNotBlank(testItemGroupId)) {
			TestItemGroup testItemGroup = (TestItemGroup) DataProvider.get().getObjectOf(TestItemGroup.class, testItemGroupId);
			if (testItemGroup != null) {
				return testItemGroup.getName();
			}
		}

		return "";
	}

	public void putHTMLResult(String htmlResult) {
		addProperty("html.result", htmlResult); //$NON-NLS-1$
	}

	public String getHTMLResult() {
		return getProperty("html.result", ""); //$NON-NLS-1$ //$NON-NLS-2$
	}

	//	public void putVisible(boolean visible) {
	//		addProperty(JESON_PROP_VISIBLE, String.valueOf(visible));
	//	}
	//
	//	public boolean isVisible() {
	//		return getBooleanProperty(JESON_PROP_VISIBLE, Boolean.TRUE);
	//	}

	public void putMachineName(String htmlResult) {
		addProperty("machine.name", htmlResult); //$NON-NLS-1$
	}

	public String getMachineName() {
		return getProperty("machine.name", ""); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public void putShowTestItem(boolean showTestItem) {
		addProperty("show.test.item", String.valueOf(showTestItem));
	}

	public boolean isShowTestItem() {
		return getBooleanProperty("show.test.item", Boolean.TRUE);
	}

	public void putBoldTestItem(boolean hideTestItem) {
		addProperty("bold.test.item", String.valueOf(hideTestItem));
	}

	public boolean isBoldTestItem() {
		return getBooleanProperty("bold.test.item", Boolean.FALSE);
	}

	public void putItalicTestItem(boolean hideTestItem) {
		addProperty("italic.test.item", String.valueOf(hideTestItem));
	}

	public boolean isItalicTestItem() {
		return getBooleanProperty("italic.test.item", Boolean.FALSE);
	}

	public void putRedTestItem(boolean hideTestItem) {
		addProperty("red.test.item", String.valueOf(hideTestItem));
	}

	public boolean isRedTestItem() {
		return getBooleanProperty("red.test.item", Boolean.FALSE);
	}

	public void putPredefinedResultValue(String preDefinedResultValue) {
		addProperty("predefined.test.item.results", preDefinedResultValue);
	}

	public String getPredefinedResultValue() {
		return getProperty("predefined.test.item.results", "");
	}

	public List<String> getPredefinedResults() {
		List<String> predefinedResults = new ArrayList<String>();
		String predefinedValue = getPredefinedResultValue();
		if (StringUtils.isBlank(predefinedValue)) {
			return predefinedResults;
		}
		if (!predefinedValue.contains("|")) {
			return predefinedResults;
		}

		String[] split = predefinedValue.split("\\|");
		if (split != null && split.length > 0) {
			for (String predefinedResult : split) {
				if (StringUtils.isNotBlank(predefinedResult)) {
					predefinedResults.add(predefinedResult.trim());
				}
			}

			String result = getResult();
			if (!predefinedResults.contains(result) && StringUtils.isNotBlank(result)) {
				predefinedResults.add(result);
			}
		}
		return predefinedResults;
	}

	public void putFormulaEnable(boolean enable) {
		addProperty("formula.enable", String.valueOf(enable));
	}

	public boolean isFormulaEnable() {
		//return getBooleanProperty("formula.enable", false);
		return StringUtils.isNotBlank(getFormulaString());
	}

	public void putFormulaString(String formula) {
		addProperty("formula.string", formula);
	}

	public String getFormulaString() {
		return getProperty("formula.string", StringUtils.EMPTY);
	}

	public void putOriginalMachineResult(String machineResult) {
		addProperty("machine.result.original", machineResult);
	}

	public String getOriginalMachineResult() {
		return getProperty("machine.result.original");
	}

	//public String getMachineCodeEscaped() {
	//	String machineCode = getMachineCode();
	//	if (StringUtils.isNotBlank(machineCode)) {
	//		machineCode = machineCode.replaceAll("%", "_");
	//	}
	//	
	//	return machineCode;
	//}
	//
	//public String getFormulaStringEscaped() {
	//	String formulaString = getFormulaString();
	//	if (StringUtils.isNotBlank(formulaString)) {
	//		formulaString = formulaString.replaceAll("%", "_");
	//	}
	//	
	//	return formulaString;
	//}
}