package com.floreantpos.model.ext;

import com.floreantpos.Messages;

public enum StripeEvent {

	CHARGE_FAILED("charge.failed", Messages.getString("PaymentFailed")), //$NON-NLS-1$ //$NON-NLS-2$
	INVOICE_PAYMENT_FAILED("invoice.payment_failed", Messages.getString("PaymentFailed")); //$NON-NLS-1$ //$NON-NLS-2$

	private final String type;
	private final String message;

	StripeEvent(String type, String message) {
		this.type = type;
		this.message = message;
	}

	public String value() {
		return type;
	}

	public String getMessage() {
		return message;
	}

	public static StripeEvent fromValue(String type) {
		for (StripeEvent c : StripeEvent.values()) {
			if (c.type.equals(type)) {
				return c;
			}
		}
		return null;
	}
}
