package com.floreantpos.model.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import com.floreantpos.PosLog;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.MenuItem;

public class SortUtil {
	public static void sortVariants(List<MenuItem> variants) {
		if (variants == null || variants.isEmpty()) {
			return;
		}
		try {
			if (variants.get(0).getVariantSortOrder() == null) {
				return;
			}
			for (MenuItem menuItem : variants) {
				if (menuItem.getAttributes() != null) {
					Collections.sort(menuItem.getAttributes(), new Comparator<Attribute>() {

						@Override
						public int compare(Attribute o1, Attribute o2) {
							return o1.getGroup().getSortOrder().compareTo(o2.getGroup().getSortOrder());
						}
					});
				}
			}
			Collections.sort(variants, new Comparator<MenuItem>() {

				@Override
				public int compare(MenuItem o1, MenuItem o2) {
					Integer sortOrder1 = o1.getVariantSortOrder();
					if (sortOrder1 == null) {
						sortOrder1 = 0;
					}
					Integer sortOrder2 = o2.getVariantSortOrder();
					if (sortOrder2 == null) {
						sortOrder2 = 0;
					}
					return sortOrder1.compareTo(sortOrder2);
				}
			});
		} catch (Exception e) {
			PosLog.error(SortUtil.class, e);
		}
	}
}
