package com.floreantpos.report.model;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.Department;
import com.floreantpos.model.Doctor;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.dao.DoctorDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ListTableModel;

public class LabDoctorPaymentsReportModel extends ListTableModel {
	public LabDoctorPaymentsReportModel() {
		super(new String[] { "customerName", "orderId", "orderDate", "date", "paymentType", "amount", "department", "customerId" });
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		PosTransaction reportData = (PosTransaction) rows.get(rowIndex);
		switch (columnIndex) {
			case 0:
				return reportData.getRecepientCustomerName();
			case 1:
				return reportData.getTransTicketIdsDisplay();
			case 2:
				return reportData.getOrderDateDisplayString();
			case 3:
				return reportData.getDateDisplayString();

			case 4:

				return reportData.getPaymentTypeDisplayString();

			case 5:
				Double amount = reportData.getAmount();
				if (amount.isNaN()) {
					return 0d;
				}
				return amount;

			case 6:

				String accountNumber = reportData.getRecepientId();
				Doctor doctor = accountNumber == null ? null : DoctorDAO.getInstance().get(accountNumber);
				if (doctor == null) {
					return "";
				}
				String departmentId = doctor.getDoctorDepartmentId();
				if (StringUtils.isNotBlank(departmentId)) {
					Department department = DataProvider.get().getDepartmentById(departmentId);
					if (department == null) {
						return "";
					}
					return department.getName();
				}
				return "";
			case 7:
				return reportData.getRecepientId();
		}
		return null;
	}

}