package com.floreantpos.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import com.floreantpos.model.AddressContainer;
import com.floreantpos.model.MenuItem;

public class CopyUtil {
	public static MenuItem copy(MenuItem source) throws Exception {
		return source.clone();
	}
	
	public static Object deepCopy(Object input) throws Exception {
		Object output = null;
		try {
			// write
			ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
			ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
			objectOutputStream.writeObject(input);

			// read
			ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
			ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
			output = objectInputStream.readObject();

		} catch (Exception e) {
			throw e;
		}
		return output;
	}
	
	public static void copyAddress(AddressContainer fromAddress, AddressContainer toAddressContainer) {
		toAddressContainer.setAddressLine1(fromAddress.getAddressLine1());
		toAddressContainer.setAddressLine2(fromAddress.getAddressLine2());
		toAddressContainer.setAddressLine3(fromAddress.getAddressLine3());
		toAddressContainer.setCountry(fromAddress.getCountry());
		toAddressContainer.setState(fromAddress.getState());
		toAddressContainer.setCity(fromAddress.getCity());
		toAddressContainer.setZipCode(fromAddress.getZipCode());
		toAddressContainer.setTelephone(fromAddress.getTelephone());
	}
}
