package com.floreantpos.model;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseNotification;
import com.floreantpos.model.ext.StripeEvent;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.model.util.MqttCommand;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "" })
@XmlRootElement
public class Notification extends BaseNotification implements PropertyContainer, TimedModel {
	private static final long serialVersionUID = 1L;
	public static final String TYPE_MEDLOGICS_GLOBAL = MqttCommand.TOPIC_MEDLOGICS_NOTIFICATION;
	private transient JsonObject propertiesContainer;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Notification() {
	}

	/**
	 * Constructor for primary key
	 */
	public Notification(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public String getMessageTitle() {
		StripeEvent stripeEvent = StripeEvent.fromValue(getEventType());
		if (stripeEvent == null) {
			return ""; //$NON-NLS-1$
		}
		return stripeEvent.getMessage();
	}

	@XmlTransient
	@JsonIgnore
	public int getNotificationTimeout() {
		return POSUtil.parseInteger(getProperty("notification_timeout")); //$NON-NLS-1$
	}

	public void setNotificationTimeout(int notificationTimeout) {
		addProperty("notification_timeout", String.valueOf(notificationTimeout)); //$NON-NLS-1$
	}

	@Override
	public void addProperty(String key, String value) {
		this.getPropertyStore().addProperty(key, value);
		setProperties(this.getPropertyStore().toString());
	}

	@Override
	public String getProperties() {
		return buildProperties();
	}

	public String buildProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}
		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		return propertiesContainer;
	}

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	public String getFormattedCreateDate() {
		if (super.getCreatedDate() == null) {
			return ""; //$NON-NLS-1$
		}
		return DateUtil.formatDateWithBrowserTimeOffset(getCreatedDate());
	}

}