package com.orocube.rest.service;

import com.fasterxml.jackson.annotation.JsonRootName;
import com.floreantpos.Messages;
import com.floreantpos.model.util.DataProvider;

@JsonRootName("response")
public class PosResponse {
	public static final int STORE_CLOSED = 9999;
	public static final int SUCCESS = 1;
	public static final int ERROR = 0;
	public static final int TERMINAL_NOT_REGISTERED = 901;
	public static final int TERMINAL_NOT_FOUND = 902;
	public static final String MSG_SUCCESS = "success"; //$NON-NLS-1$

	public static final String SOURCE = "source";
	public static final String REQUEST = "request";
	public static final String DEVICE_ID = "deviceId";
	public static final String OUTLET_ID = "outletId";
	public static final String BLOCK_TERMINAL_ID = "blockTerminalId";

	private int responseCode = 0;
	private String request;
	private String msg;
	private Object data;
	private Object linkedData;
	private String deviceId;
	private String storeId;
	private String outletId;
	private String sourceTerminalKey;
	private String customerId;
	private String source;
	private int totalRowCount;

	public int getResponseCode() {
		return responseCode;
	}

	public void setResponseCode(int responseCode) {
		this.responseCode = responseCode;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public Object getData() {
		return data;
	}

	public void setData(Object data) {
		this.data = data;
	}

	public String getDeviceId() {
		return deviceId;
	}

	public void setDeviceId(String deviceId) {
		this.deviceId = deviceId;
	}

	public String getRequest() {
		return request;
	}

	public void setRequest(String request) {
		this.request = request;
	}

	public static String storeClosed() throws Exception {
		PosResponse response = new PosResponse();
		response.setResponseCode(STORE_CLOSED);
		response.setMsg(Messages.getString("PosResponse.1")); //$NON-NLS-1$
		response.setRequest(Messages.getString("PosResponse.0")); //$NON-NLS-1$
		response.setDeviceId(DataProvider.get().getMqttDeviceId());
		response.setData(""); //$NON-NLS-1$
		return ServiceUtils.getAsJsonString(response);
	}

	public static PosResponse create(int responseCode, String msg) {
		PosResponse reponse = new PosResponse();
		reponse.setResponseCode(responseCode);
		reponse.setDeviceId(DataProvider.get().getMqttDeviceId());
		reponse.setMsg(msg);
		return reponse;
	}

	public String getStoreId() {
		return storeId;
	}

	public void setStoreId(String storeId) {
		this.storeId = storeId;
	}

	public Object getLinkedData() {
		return linkedData;
	}

	public void setLinkedData(Object linkedData) {
		this.linkedData = linkedData;
	}

	public String getSourceTerminalKey() {
		return sourceTerminalKey;
	}

	public void setSourceTerminalKey(String sourceTerminalKey) {
		this.sourceTerminalKey = sourceTerminalKey;
	}

	public String getOutletId() {
		return outletId;
	}

	public void setOutletId(String outletId) {
		this.outletId = outletId;
	}

	public String getCustomerId() {
		return customerId;
	}

	public void setCustomerId(String customerId) {
		this.customerId = customerId;
	}

	public String getSource() {
		return source;
	}

	public void setSource(String source) {
		this.source = source;
	}

	public int getTotalRowCount() {
		return totalRowCount;
	}

	public void setTotalRowCount(int totalRowCount) {
		this.totalRowCount = totalRowCount;
	}
}
