package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosLog;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.swing.PaginatedListModel;

public class MenuPageDAO extends BaseMenuPageDAO {

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	public void saveOrUpdatePages(List<MenuPage> items) {
		Session session = null;
		Transaction tx = null;
		try {
			session = createNewSession();
			tx = session.beginTransaction();
			for (Iterator iterator = items.iterator(); iterator.hasNext();) {
				MenuPage menuPage = (MenuPage) iterator.next();
				session.saveOrUpdate(menuPage);
			}
			tx.commit();
		} catch (Exception e) {
			tx.rollback();
			PosLog.error(getClass(), e);
		} finally {
			session.close();
		}
	}

	//	public int getRowCount(Terminal terminal, MenuGroup menuGroup, Object selectedOrderType) {
	//		Session session = null;
	//		Criteria criteria = null;
	//		try {
	//			session = createNewSession();
	//			criteria = session.createCriteria(getReferenceClass());
	//
	//			if (menuGroup != null) {
	//				criteria.add(Restrictions.eq(MenuPage.PROP_MENU_GROUP_ID, menuGroup.getId()));
	//			}
	//			addOrderTypeCriteria((OrderType) selectedOrderType, criteria);
	//			criteria.add(Restrictions.eq(MenuPage.PROP_VISIBLE, Boolean.TRUE));
	//			criteria.setProjection(Projections.rowCount());
	//
	//			Number rowCount = (Number) criteria.uniqueResult();
	//			if (rowCount != null) {
	//				return rowCount.intValue();
	//
	//			}
	//		} finally {
	//			closeSession(session);
	//		}
	//		return 0;
	//	}

	public List<MenuPage> findByGroup(MenuGroup menuGroup) {
		Criteria criteria = null;
		try (Session session = createNewSession()) {
			criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(MenuPage.PROP_MENU_GROUP_ID, menuGroup.getId()));
			criteria.addOrder(Order.asc(MenuPage.PROP_SORT_ORDER));
			return criteria.list();
		}
	}

	public void loadItems(Terminal terminal, MenuGroup menuGroup, OrderType selectedOrderType, Boolean visible, PaginatedListModel listModel) {
		Criteria criteria = null;
		try (Session session = createNewSession()) {
			criteria = session.createCriteria(getReferenceClass());
			if (menuGroup != null) {
				criteria.add(Restrictions.eq(MenuPage.PROP_MENU_GROUP_ID, menuGroup.getId()));
			}
			addOrderTypeCriteria(selectedOrderType, criteria);
			criteria.add(Restrictions.eq(MenuPage.PROP_VISIBLE, Boolean.TRUE));

			listModel.setNumRows(rowCount(criteria));

			criteria.addOrder(Order.asc(MenuPage.PROP_SORT_ORDER));
			criteria.setFirstResult(listModel.getCurrentRowIndex());
			criteria.setMaxResults(1);
			listModel.setData(criteria.list());
		}
	}

	private void addOrderTypeCriteria(OrderType selectedOrderType, Criteria criteria) {
		if (selectedOrderType != null) {
			String id = selectedOrderType.getId();
			criteria.add(Restrictions.or(Restrictions.isNull(MenuPage.PROP_ORDER_TYPE_ID), Restrictions.eq(MenuPage.PROP_ORDER_TYPE_ID, id)));
		}
		//		else {
		//			criteria.add(Restrictions.isNull(MenuPage.PROP_ORDER_TYPE_ID));
		//		}
	}

	public void deleteAll(List<MenuPage> items) {
		Session session = null;
		Transaction tx = null;
		try {
			session = createNewSession();
			tx = session.beginTransaction();
			deleteAll(items, session);
			tx.commit();
		} catch (Exception e) {
			tx.rollback();
			throw e;
		} finally {
			session.close();
		}

	}

	public void deleteAll(List<MenuPage> items, Session session) {
		for (Iterator iterator = items.iterator(); iterator.hasNext();) {
			MenuPage menuPage = (MenuPage) iterator.next();
			MenuPage menuPage2 = session.get(MenuPage.class, menuPage.getId());
			session.delete(menuPage2);
		}
	}

	public void addToMenuGroupEndPage(MenuItem mnuItem) {
		if (mnuItem.getMenuGroupId() == null)
			return;
		MenuItemDAO.getInstance().initialize(mnuItem);
		MenuPage page = getLastPage(mnuItem.getMenuGroupId());
		MenuPageItem menuPageItem = new MenuPageItem(null, null, mnuItem, page);
		for (int i = 0; i < page.getRows(); i++) {
			for (int j = 0; j < page.getCols(); j++) {
				if (page.getItemForCell(j, i) == null) {
					menuPageItem.setCol(j);
					menuPageItem.setRow(i);
					menuPageItem.setMenuPage(page);
					MenuPageItemDAO.getInstance().saveOrUpdate(page);
					return;
				}
			}
		}
	}

	private MenuPage getLastPage(String menuGroupId) {
		Criteria criteria = null;
		try (Session session = createNewSession()) {
			criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(MenuPage.PROP_MENU_GROUP_ID, menuGroupId));
			criteria.addOrder(Order.asc(MenuPage.PROP_SORT_ORDER));

			List list = criteria.list();
			MenuPage page = null;
			if (list != null && !list.isEmpty()) {
				page = (MenuPage) list.get(list.size() - 1);
			}
			List<MenuPageItem> pageItems = null;
			if (page != null) {
				pageItems = MenuPageItemDAO.getInstance().getPageItems(page);
			}
			if (page == null || (pageItems != null && !pageItems.isEmpty() && pageItems.size() == (page.getRows() * page.getCols()))) {
				page = new MenuPage();
				page.setMenuGroupId(menuGroupId);
				int pageNumber = list.size() + 1;
				page.setName("Page " + pageNumber);
				page.setSortOrder(pageNumber);
				page.setCols(5);
				page.setRows(5);
				page.setButtonHeight(120);
				page.setButtonWidth(120);
				page.setVisible(true);
			}
			return page;
		}
	}

	public void initialize(MenuPage menuPage) {
		if (menuPage == null || Hibernate.isInitialized(menuPage.getPageItems())) {
			return;
		}
		try (Session session = createNewSession()) {
			session.refresh(menuPage);
			Hibernate.initialize(menuPage.getPageItems());
		}
	}

	public MenuPage getInitialized(String menuPageId) {
		if (menuPageId == null) {
			return null;
		}
		try (Session session = createNewSession()) {
			MenuPage menuPage = session.get(MenuPage.class, menuPageId);
			Hibernate.initialize(menuPage.getPageItems());
			return menuPage;
		}
	}

	/*
	 * This method is used for cloud pos to get page count by menu category
	 */
	public int getRowCount(Terminal terminal, List<String> menuGroupIds, Object selectedOrderType) {
		if (menuGroupIds == null || menuGroupIds.size() == 0) {
			return 0;
		}
		Criteria criteria = null;
		try (Session session = createNewSession()) {
			criteria = session.createCriteria(getReferenceClass());

			criteria.add(Restrictions.in(MenuPage.PROP_MENU_GROUP_ID, menuGroupIds));
			criteria.add(Restrictions.eq(MenuPage.PROP_VISIBLE, Boolean.TRUE));
			criteria.setProjection(Projections.rowCount());

			Number rowCount = (Number) criteria.uniqueResult();
			if (rowCount != null) {
				return rowCount.intValue();

			}
		}
		return 0;
	}

	/*
	 * This method is used for cloud pos to get page by menu category
	 */
	public void loadItems(Terminal terminal, List<String> menuGroupIds, OrderType selectedOrderType, Boolean visible, PaginatedListModel listModel) {
		if (menuGroupIds == null || menuGroupIds.size() == 0) {
			return;
		}
		Session session = null;
		Criteria criteria = null;
		try {
			session = createNewSession();
			criteria = session.createCriteria(getReferenceClass());
			criteria.addOrder(Order.asc(MenuPage.PROP_SORT_ORDER));
			criteria.add(Restrictions.in(MenuPage.PROP_MENU_GROUP_ID, menuGroupIds));
			criteria.add(Restrictions.eq(MenuPage.PROP_VISIBLE, Boolean.TRUE));
			criteria.setFirstResult(listModel.getCurrentRowIndex());
			criteria.setMaxResults(1);
			listModel.setData(criteria.list());
		} finally {
			closeSession(session);
		}
	}
	/*
	 * method end
	 */

	public void saveOrUpdateMenuPageList(List<MenuPage> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
		if (dataList == null)
			return;

		Transaction tx = null;
		try (Session session = createNewSession()) {
			tx = session.beginTransaction();

			for (Iterator<MenuPage> iterator = dataList.iterator(); iterator.hasNext();) {
				MenuPage menuPage = (MenuPage) iterator.next();
				MenuPage existingMenuPage = get(menuPage.getId());
				if (existingMenuPage != null) {
					initialize(existingMenuPage);
				}
				List<MenuPageItem> pageItems = menuPage.getPageItems();

				menuPage.setUpdateLastUpdateTime(updateLastUpdateTime);
				menuPage.setUpdateSyncTime(updateSyncTime);
				menuPage.setPageItems(null);

				saveOrUpdateMenuPage(session, menuPage, existingMenuPage);
				saveOrUpdateMenuPageItems(session, menuPage, existingMenuPage, pageItems);

				menuPage.setPageItems(pageItems);
				saveOrUpdate(menuPage, session);
			}
			tx.commit();
		} catch (Exception e) {
			tx.rollback();
			throw e;
		}

	}

	private void saveOrUpdateMenuPageItems(Session session, MenuPage menuPage, MenuPage existingMenuPage, List<MenuPageItem> pageItems) {
		if (pageItems == null || pageItems.isEmpty()) {
			return;
		}
		List<MenuPageItem> existingPageItems = null;
		if (existingMenuPage != null) {
			existingPageItems = existingMenuPage.getPageItems();
		}
		for (MenuPageItem pageItem : pageItems) {
			pageItem.setMenuPage(menuPage);

			saveOrUpdateMenuPageItem(session, pageItem, existingPageItems);
		}

	}

	private void saveOrUpdateMenuPageItem(Session session, MenuPageItem pageItem, List<MenuPageItem> existingPageItems) {
		MenuPageItemDAO menuPageItemDAO = new MenuPageItemDAO();

		MenuPageItem existingMenuPageItem = null;

		if (existingPageItems == null || existingPageItems.isEmpty()) {
			menuPageItemDAO.save(pageItem, session);
		}
		else {
			int idx = existingPageItems.indexOf(pageItem);
			if (idx != -1) {
				existingMenuPageItem = existingPageItems.get(idx);
				if (existingMenuPageItem == null) {
					menuPageItemDAO.save(pageItem, session);
				}
				else {
					pageItem.setVersion(existingMenuPageItem.getVersion());
				}
			}
			else {
				menuPageItemDAO.save(pageItem, session);
			}
		}
	}

	private void saveOrUpdateMenuPage(Session session, MenuPage menuPage, MenuPage existingMenuPage) {
		if (existingMenuPage == null) {
			save(menuPage, session);
		}
		else {
			menuPage.setVersion(existingMenuPage.getVersion());
		}
	}
}