package com.floreantpos.model.ext;

import java.io.Serializable;

public class UnitBaseItemPrice implements Serializable {
	private String unitName;
	private String unitId;
	private Double price;

	public UnitBaseItemPrice() {
	}

	public UnitBaseItemPrice(String unitCode, Double price) {
		super();
		this.unitId = unitCode;
		this.price = price;
	}

	public UnitBaseItemPrice(String unitName, String unitId, Double price) {
		super();
		this.unitName = unitName;
		this.unitId = unitId;
		this.price = price;
	}

	public String getUnitId() {
		return unitId;
	}

	public void setUnitId(String unitCode) {
		this.unitId = unitCode;
	}

	public Double getPrice() {
		return price == null ? Double.valueOf(0) : price;
	}

	public void setPrice(Double price) {
		this.price = price;
	}

	public String getUnitName() {
		return unitName;
	}

	public void setUnitName(String unitName) {
		this.unitName = unitName;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((unitId == null) ? 0 : unitId.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		UnitBaseItemPrice other = (UnitBaseItemPrice) obj;
		if (unitId == null) {
			if (other.unitId != null)
				return false;
		}
		else if (!unitId.equals(other.unitId))
			return false;
		return true;
	}

	@Override
	public String toString() {
		return "(packagingUnitName=" + unitName + ", packagingUnitId=" + unitId + ", price=" + price + ")";
	}
}
