package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the GRATUITY table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="GRATUITY"
 */

public abstract class BaseGratuity  implements Comparable, Serializable {

	public static String REF = "Gratuity"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_AMOUNT = "amount"; //$NON-NLS-1$
	public static String PROP_PAID = "paid"; //$NON-NLS-1$
	public static String PROP_HAS_SYNC_ERROR = "hasSyncError"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_TICKET_ID = "ticketId"; //$NON-NLS-1$
	public static String PROP_OWNER_ID = "ownerId"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_CLOUD_SYNCED = "cloudSynced"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_DECLARE_TIPS_AMOUNT = "declareTipsAmount"; //$NON-NLS-1$
	public static String PROP_TERMINAL_ID = "terminalId"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_TIPS_PAID_AMOUNT = "tipsPaidAmount"; //$NON-NLS-1$
	public static String PROP_REFUNDED = "refunded"; //$NON-NLS-1$


	// constructors
	public BaseGratuity () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseGratuity (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.Double amount;
				private java.lang.Double declareTipsAmount;
				private java.lang.Double tipsPaidAmount;
				private java.lang.Boolean paid;
				private java.lang.Boolean refunded;
				private java.lang.String ticketId;
				private java.lang.String ownerId;
				private java.lang.Integer terminalId;
				private java.lang.String outletId;
				private java.lang.Boolean cloudSynced;
				private java.lang.Boolean hasSyncError;
				private java.lang.String properties;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: AMOUNT
	 */

	public java.lang.Double getAmount () {
						return amount == null ? Double.valueOf(0) : amount;
		}



	/**
	 * Set the value related to the column: AMOUNT
	 * @param amount the AMOUNT value
	 */
			public void setAmount (java.lang.Double amount) {
			this.amount = amount;
	}



	/**
	 * Return the value associated with the column: DECLARE_TIPS_AMOUNT
	 */

	public java.lang.Double getDeclareTipsAmount () {
						return declareTipsAmount == null ? Double.valueOf(0) : declareTipsAmount;
		}



	/**
	 * Set the value related to the column: DECLARE_TIPS_AMOUNT
	 * @param declareTipsAmount the DECLARE_TIPS_AMOUNT value
	 */
			public void setDeclareTipsAmount (java.lang.Double declareTipsAmount) {
			this.declareTipsAmount = declareTipsAmount;
	}



	/**
	 * Return the value associated with the column: TIPS_PAID_AMOUNT
	 */

	public java.lang.Double getTipsPaidAmount () {
						return tipsPaidAmount == null ? Double.valueOf(0) : tipsPaidAmount;
		}



	/**
	 * Set the value related to the column: TIPS_PAID_AMOUNT
	 * @param tipsPaidAmount the TIPS_PAID_AMOUNT value
	 */
			public void setTipsPaidAmount (java.lang.Double tipsPaidAmount) {
			this.tipsPaidAmount = tipsPaidAmount;
	}



	/**
	 * Return the value associated with the column: PAID
	 */

	public java.lang.Boolean isPaid () {
					return paid == null ? Boolean.FALSE : paid;
		}

	public java.lang.Boolean getPaid () {
				return paid == null ? Boolean.FALSE : paid;
			}


	/**
	 * Set the value related to the column: PAID
	 * @param paid the PAID value
	 */
			public void setPaid (java.lang.Boolean paid) {
			this.paid = paid;
	}



	/**
	 * Return the value associated with the column: REFUNDED
	 */

	public java.lang.Boolean isRefunded () {
					return refunded == null ? Boolean.FALSE : refunded;
		}

	public java.lang.Boolean getRefunded () {
				return refunded == null ? Boolean.FALSE : refunded;
			}


	/**
	 * Set the value related to the column: REFUNDED
	 * @param refunded the REFUNDED value
	 */
			public void setRefunded (java.lang.Boolean refunded) {
			this.refunded = refunded;
	}



	/**
	 * Return the value associated with the column: TICKET_ID
	 */

	public java.lang.String getTicketId () {
			return ticketId;
	}



	/**
	 * Set the value related to the column: TICKET_ID
	 * @param ticketId the TICKET_ID value
	 */
			public void setTicketId (java.lang.String ticketId) {
			this.ticketId = ticketId;
	}



	/**
	 * Return the value associated with the column: OWNER_ID
	 */

	public java.lang.String getOwnerId () {
			return ownerId;
	}



	/**
	 * Set the value related to the column: OWNER_ID
	 * @param ownerId the OWNER_ID value
	 */
			public void setOwnerId (java.lang.String ownerId) {
			this.ownerId = ownerId;
	}



	/**
	 * Return the value associated with the column: TERMINAL_ID
	 */

	public java.lang.Integer getTerminalId () {
						return terminalId == null ? Integer.valueOf(0) : terminalId;
		}



	/**
	 * Set the value related to the column: TERMINAL_ID
	 * @param terminalId the TERMINAL_ID value
	 */
			public void setTerminalId (java.lang.Integer terminalId) {
			this.terminalId = terminalId;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: CLOUD_SYNCED
	 */

	public java.lang.Boolean isCloudSynced () {
					return cloudSynced == null ? Boolean.FALSE : cloudSynced;
		}

	public java.lang.Boolean getCloudSynced () {
				return cloudSynced == null ? Boolean.FALSE : cloudSynced;
			}


	/**
	 * Set the value related to the column: CLOUD_SYNCED
	 * @param cloudSynced the CLOUD_SYNCED value
	 */
			public void setCloudSynced (java.lang.Boolean cloudSynced) {
			this.cloudSynced = cloudSynced;
	}



	/**
	 * Return the value associated with the column: HAS_SYNC_ERROR
	 */

	public java.lang.Boolean isHasSyncError () {
					return hasSyncError == null ? Boolean.FALSE : hasSyncError;
		}

	public java.lang.Boolean getHasSyncError () {
				return hasSyncError == null ? Boolean.FALSE : hasSyncError;
			}


	/**
	 * Set the value related to the column: HAS_SYNC_ERROR
	 * @param hasSyncError the HAS_SYNC_ERROR value
	 */
			public void setHasSyncError (java.lang.Boolean hasSyncError) {
			this.hasSyncError = hasSyncError;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.Gratuity)) return false;
		else {
			com.floreantpos.model.Gratuity gratuity = (com.floreantpos.model.Gratuity) obj;
			if (null == this.getId() || null == gratuity.getId()) return this == obj;
			else return (this.getId().equals(gratuity.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}