package com.floreantpos.db.update;

import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.Address;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.AddressDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.StoreDAO;

public class UpdateDBTo260 {

	public void update() throws Exception {
		Store store = StoreDAO.getRestaurant();
		Address address = store.getAddress();
		if (address != null) {
			store.setAddressLine1(address.getAddressLine1());
			store.setAddressLine2(address.getAddressLine2());
			store.setAddressLine3(address.getAddressLine3());
			store.setCountry(address.getCountry());
			store.setCountryCode(address.getCountryCode());
			store.setState(address.getState());
			store.setCity(address.getCity());
			store.setZipCode(address.getZipCode());
			
			StoreDAO.getInstance().update(store);
		}
		
		OutletDAO outletDAO = OutletDAO.getInstance();
		List<Outlet> outlets = outletDAO.findAll();
		for (Outlet outlet : outlets) {
			String addressId = outlet.getAddressId();
			if (StringUtils.isNotBlank(addressId)) {
				address = AddressDAO.getInstance().get(addressId);
				if (address != null) {
					outlet.setAddressLine1(address.getAddressLine1());
					outlet.setAddressLine2(address.getAddressLine2());
					outlet.setAddressLine3(address.getAddressLine3());
					outlet.setCountry(address.getCountry());
					outlet.setState(address.getState());
					outlet.setCity(address.getCity());
					outlet.setZipCode(address.getZipCode());
					
					outletDAO.update(outlet);
				}
			}
		}
	}
}
