package io.github.escposjava.print;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;

public class NetworkPrinter implements Printer {
	private OutputStream printer = null;
	private final String address;
	private final int port;
	private Socket socket;

	public NetworkPrinter(String address, int port) {
		this.address = address;
		this.port = port;
	}

	public void open() {
		try {
			socket = new Socket();
			socket.connect(new InetSocketAddress(this.address, this.port), 500);
			printer = socket.getOutputStream();
		} catch (SocketTimeoutException e) {
			throw new PosException(Messages.getString("NetworkPrinter.0")); //$NON-NLS-1$
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	public boolean isConnected() {
		return printer != null;
	}

	public void write(byte[] command) {
		try {
			printer.write(command);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

	public void close() {
		try {
			printer.close();
			socket.close();
		} catch (Exception e) {
			PosLog.error(getClass(), e);
		}
	}

}
