package com.floreantpos.model.base;

import java.lang.Comparable;

import com.floreantpos.model.DefaultMenuModifier;

import java.io.Serializable;


/**
 * This is an object that contains data related to the MENUITEM_MODIFIERSPEC table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="MENUITEM_MODIFIERSPEC"
 */

public abstract class BaseMenuItemModifierSpec  implements Comparable, Serializable {

	public static String REF = "MenuItemModifierSpec"; //$NON-NLS-1$
	public static String PROP_EXCLUSIVE = "exclusive"; //$NON-NLS-1$
	public static String PROP_SORT_ORDER = "sortOrder"; //$NON-NLS-1$
	public static String PROP_AUTO_SHOW = "autoShow"; //$NON-NLS-1$
	public static String PROP_INSTRUCTION = "instruction"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_MODIFIER_GROUP_ID = "modifierGroupId"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_MIN_QUANTITY = "minQuantity"; //$NON-NLS-1$
	public static String PROP_JUMP_GROUP = "jumpGroup"; //$NON-NLS-1$
	public static String PROP_REQUIRED = "required"; //$NON-NLS-1$
	public static String PROP_ENABLE = "enable"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_TRANSLATED_NAME = "translatedName"; //$NON-NLS-1$
	public static String PROP_MAX_QUANTITY = "maxQuantity"; //$NON-NLS-1$
	public static String PROP_MENU_ITEM_ID = "menuItemId"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$


	// constructors
	public BaseMenuItemModifierSpec () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseMenuItemModifierSpec (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	private long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String name;
				private java.lang.String translatedName;
				private java.lang.String instruction;
				private java.lang.Boolean enable;
				private java.lang.Boolean exclusive;
				private java.lang.Boolean required;
				private java.lang.Integer minQuantity;
				private java.lang.Integer maxQuantity;
				private java.lang.Integer sortOrder;
				private java.lang.Boolean jumpGroup;
				private java.lang.Boolean autoShow;
				private java.lang.String modifierGroupId;
				private java.lang.String menuItemId;
				private java.lang.String properties;
	
	// collections
	private java.util.Set<com.floreantpos.model.MenuItemModifierPage> modifierPages;
	private java.util.List<DefaultMenuModifier> defaultModifierList;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: TRANSLATED_NAME
	 */

	public java.lang.String getTranslatedName () {
			return translatedName;
	}



	/**
	 * Set the value related to the column: TRANSLATED_NAME
	 * @param translatedName the TRANSLATED_NAME value
	 */
			public void setTranslatedName (java.lang.String translatedName) {
			this.translatedName = translatedName;
	}



	/**
	 * Return the value associated with the column: INSTRUCTION
	 */

	public java.lang.String getInstruction () {
			return instruction;
	}



	/**
	 * Set the value related to the column: INSTRUCTION
	 * @param instruction the INSTRUCTION value
	 */
			public void setInstruction (java.lang.String instruction) {
			this.instruction = instruction;
	}



	/**
	 * Return the value associated with the column: ENABLED
	 */

	public java.lang.Boolean isEnable () {
					return enable == null ? Boolean.FALSE : enable;
		}

	public java.lang.Boolean getEnable () {
				return enable == null ? Boolean.FALSE : enable;
			}


	/**
	 * Set the value related to the column: ENABLED
	 * @param enable the ENABLED value
	 */
			public void setEnable (java.lang.Boolean enable) {
			this.enable = enable;
	}



	/**
	 * Return the value associated with the column: EXCLUSIVE
	 */

	public java.lang.Boolean isExclusive () {
					return exclusive == null ? Boolean.FALSE : exclusive;
		}

	public java.lang.Boolean getExclusive () {
				return exclusive == null ? Boolean.FALSE : exclusive;
			}


	/**
	 * Set the value related to the column: EXCLUSIVE
	 * @param exclusive the EXCLUSIVE value
	 */
			public void setExclusive (java.lang.Boolean exclusive) {
			this.exclusive = exclusive;
	}



	/**
	 * Return the value associated with the column: REQUIRED
	 */

	public java.lang.Boolean isRequired () {
					return required == null ? Boolean.FALSE : required;
		}

	public java.lang.Boolean getRequired () {
				return required == null ? Boolean.FALSE : required;
			}


	/**
	 * Set the value related to the column: REQUIRED
	 * @param required the REQUIRED value
	 */
			public void setRequired (java.lang.Boolean required) {
			this.required = required;
	}



	/**
	 * Return the value associated with the column: MIN_QUANTITY
	 */

	public java.lang.Integer getMinQuantity () {
						return minQuantity == null ? Integer.valueOf(0) : minQuantity;
		}



	/**
	 * Set the value related to the column: MIN_QUANTITY
	 * @param minQuantity the MIN_QUANTITY value
	 */
			public void setMinQuantity (java.lang.Integer minQuantity) {
			this.minQuantity = minQuantity;
	}



	/**
	 * Return the value associated with the column: MAX_QUANTITY
	 */

	public java.lang.Integer getMaxQuantity () {
						return maxQuantity == null ? Integer.valueOf(0) : maxQuantity;
		}



	/**
	 * Set the value related to the column: MAX_QUANTITY
	 * @param maxQuantity the MAX_QUANTITY value
	 */
			public void setMaxQuantity (java.lang.Integer maxQuantity) {
			this.maxQuantity = maxQuantity;
	}



	/**
	 * Return the value associated with the column: SORT_ORDER
	 */

	public java.lang.Integer getSortOrder () {
						return sortOrder == null ? Integer.valueOf(0) : sortOrder;
		}



	/**
	 * Set the value related to the column: SORT_ORDER
	 * @param sortOrder the SORT_ORDER value
	 */
			public void setSortOrder (java.lang.Integer sortOrder) {
			this.sortOrder = sortOrder;
	}



	/**
	 * Return the value associated with the column: JUMP_TO_GROUP
	 */

	public java.lang.Boolean isJumpGroup () {
					return jumpGroup == null ? Boolean.FALSE : jumpGroup;
		}

	public java.lang.Boolean getJumpGroup () {
				return jumpGroup == null ? Boolean.FALSE : jumpGroup;
			}


	/**
	 * Set the value related to the column: JUMP_TO_GROUP
	 * @param jumpGroup the JUMP_TO_GROUP value
	 */
			public void setJumpGroup (java.lang.Boolean jumpGroup) {
			this.jumpGroup = jumpGroup;
	}



	/**
	 * Return the value associated with the column: AUTO_SHOW
	 */

	public java.lang.Boolean isAutoShow () {
					return autoShow == null ? Boolean.FALSE : autoShow;
		}

	public java.lang.Boolean getAutoShow () {
				return autoShow == null ? Boolean.FALSE : autoShow;
			}


	/**
	 * Set the value related to the column: AUTO_SHOW
	 * @param autoShow the AUTO_SHOW value
	 */
			public void setAutoShow (java.lang.Boolean autoShow) {
			this.autoShow = autoShow;
	}



	/**
	 * Return the value associated with the column: MODIFIER_GROUP_ID
	 */

	public java.lang.String getModifierGroupId () {
			return modifierGroupId;
	}



	/**
	 * Set the value related to the column: MODIFIER_GROUP_ID
	 * @param modifierGroupId the MODIFIER_GROUP_ID value
	 */
			public void setModifierGroupId (java.lang.String modifierGroupId) {
			this.modifierGroupId = modifierGroupId;
	}



	/**
	 * Return the value associated with the column: MENUITEM_ID
	 */

	public java.lang.String getMenuItemId () {
			return menuItemId;
	}



	/**
	 * Set the value related to the column: MENUITEM_ID
	 * @param menuItemId the MENUITEM_ID value
	 */
			public void setMenuItemId (java.lang.String menuItemId) {
			this.menuItemId = menuItemId;
	}



	/**
	 * Return the value associated with the column: modifierPages
	 */

	public java.util.Set<com.floreantpos.model.MenuItemModifierPage> getModifierPages () {
			return modifierPages;
	}



	/**
	 * Set the value related to the column: modifierPages
	 * @param modifierPages the modifierPages value
	 */
			public void setModifierPages (java.util.Set<com.floreantpos.model.MenuItemModifierPage> modifierPages) {
			this.modifierPages = modifierPages;
	}

	public void addTomodifierPages (com.floreantpos.model.MenuItemModifierPage menuItemModifierPage) {
		if (null == getModifierPages()) setModifierPages(new java.util.TreeSet<com.floreantpos.model.MenuItemModifierPage>());
		getModifierPages().add(menuItemModifierPage);
	}



	/**
	 * Return the value associated with the column: defaultModifierList
	 */
				public java.util.List<DefaultMenuModifier> getDefaultModifierList () {
			return defaultModifierList;
	}



	/**
	 * Set the value related to the column: defaultModifierList
	 * @param defaultModifierList the defaultModifierList value
	 */
			public void setDefaultModifierList (java.util.List<DefaultMenuModifier> defaultModifierList) {
			this.defaultModifierList = defaultModifierList;
	}

			/**
			 * Return the value associated with the column: PROPERTIES
			 */

			public java.lang.String getProperties () {
					return properties;
			}



			/**
			 * Set the value related to the column: PROPERTIES
			 * @param properties the PROPERTIES value
			 */
					public void setProperties (java.lang.String properties) {
					this.properties = properties;
			}



	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.MenuItemModifierSpec)) return false;
		else {
			com.floreantpos.model.MenuItemModifierSpec menuItemModifierSpec = (com.floreantpos.model.MenuItemModifierSpec) obj;
			if (null == this.getId() || null == menuItemModifierSpec.getId()) return this == obj;
			else return (this.getId().equals(menuItemModifierSpec.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}