package com.floreantpos.model.util;

import java.util.ArrayList;
import java.util.List;

import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.Address;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.BalanceUpdateTransaction;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CookingInstruction;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.Currency;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.DataSyncInfo;
import com.floreantpos.model.DeclaredTips;
import com.floreantpos.model.DeliveryAddress;
import com.floreantpos.model.DeliveryCharge;
import com.floreantpos.model.DeliveryInstruction;
import com.floreantpos.model.Department;
import com.floreantpos.model.Discount;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.GratuityPaymentHistory;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.InventoryClosingBalance;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PackagingUnit;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.ReportGroup;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Shift;
import com.floreantpos.model.SlideShowImage;
import com.floreantpos.model.StockCount;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.VoidReason;

public class SyncUtil {
	public static final String Address = "Address"; //$NON-NLS-1$
	public static final String AttendenceHistory = "AttendenceHistory"; //$NON-NLS-1$
	public static final String AttributeGroup = "AttributeGroup"; //$NON-NLS-1$
	public static final String Attribute = "Attribute"; //$NON-NLS-1$
	public static final String BookingInfo = "BookingInfo"; //$NON-NLS-1$
	//public static final String CashBreakdown = "CashBreakdown"; //$NON-NLS-1$
	public static final String CashDrawer = "CashDrawer"; //$NON-NLS-1$
	public static final String CookingInstruction = "CookingInstruction"; //$NON-NLS-1$
	public static final String CustomerGroup = "CustomerGroup"; //$NON-NLS-1$
	public static final String Customer = "Customer"; //$NON-NLS-1$
	public static final String BalanceUpdateTransaction = "BalanceUpdateTransaction"; //$NON-NLS-1$
	public static final String CustomPayment = "CustomPayment"; //$NON-NLS-1$
	public static final String Currency = "Currency"; //$NON-NLS-1$
	public static final String Course = "Course"; //$NON-NLS-1$
	public static final String DeclaredTips = "DeclaredTips"; //$NON-NLS-1$
	public static final String DeliveryAddress = "DeliveryAddress"; //$NON-NLS-1$
	public static final String DeliveryCharge = "DeliveryCharge"; //$NON-NLS-1$
	public static final String DeliveryInstruction = "DeliveryInstruction"; //$NON-NLS-1$
	public static final String Department = "Department"; //$NON-NLS-1$
	public static final String Discount = "Discount"; //$NON-NLS-1$
	public static final String GiftCard = "GiftCard"; //$NON-NLS-1$
	public static final String GratuityPaymentHistory = "GratuityPaymentHistory"; //$NON-NLS-1$
	public static final String ImageResource = "ImageResource"; //$NON-NLS-1$
	public static final String InventoryClosingBalance = "InventoryClosingBalance"; //$NON-NLS-1$
	public static final String InventoryTransaction = "InventoryTransaction"; //$NON-NLS-1$
	public static final String InventoryLocation = "InventoryLocation"; //$NON-NLS-1$
	public static final String InventoryStock = "InventoryStock"; //$NON-NLS-1$
	public static final String InventoryUnitGroup = "InventoryUnitGroup"; //$NON-NLS-1$
	public static final String InventoryVendorItems = "InventoryVendorItems"; //$NON-NLS-1$
	public static final String InventoryVendor = "InventoryVendor"; //$NON-NLS-1$
	public static final String InventoryUnit = "InventoryUnit"; //$NON-NLS-1$
	public static final String MenuCategory = "MenuCategory"; //$NON-NLS-1$
	public static final String MenuGroup = "MenuGroup"; //$NON-NLS-1$
	public static final String MenuItemModifierPage = "MenuItemModifierPage"; //$NON-NLS-1$
	public static final String MenuItemModifierSpec = "MenuItemModifierSpec"; //$NON-NLS-1$
	public static final String MenuItem = "MenuItem"; //$NON-NLS-1$
	public static final String MenuItemSize = "MenuItemSize"; //$NON-NLS-1$
	public static final String MenuPage = "MenuPage"; //$NON-NLS-1$
	public static final String ModifierGroup = "ModifierGroup"; //$NON-NLS-1$
	public static final String MenuModifier = "MenuModifier"; //$NON-NLS-1$
	public static final String Multiplier = "Multiplier"; //$NON-NLS-1$
	public static final String Outlet = "Outlet"; //$NON-NLS-1$
	public static final String OrderType = "OrderType"; //$NON-NLS-1$
	public static final String PackagingUnit = "PackagingUnit"; //$NON-NLS-1$
	public static final String PizzaCrust = "PizzaCrust"; //$NON-NLS-1$
	public static final String PizzaPrice = "PizzaPrice"; //$NON-NLS-1$
	public static final String PriceTable = "PriceTable"; //$NON-NLS-1$
	public static final String PriceRule = "PriceRule"; //$NON-NLS-1$
	public static final String SalesArea = "SalesArea"; //$NON-NLS-1$
	public static final String Shift = "Shift"; //$NON-NLS-1$
	public static final String ShopFloor = "ShopFloor"; //$NON-NLS-1$
	public static final String ShopTable = "ShopTable"; //$NON-NLS-1$
	public static final String ShopTableStatus = "ShopTableStatus"; //$NON-NLS-1$
	public static final String StoreSessionControl = "StoreSessionControl"; //$NON-NLS-1$
	public static final String StoreSession = "StoreSession"; //$NON-NLS-1$
	public static final String Tax = "Tax"; //$NON-NLS-1$
	public static final String TaxGroup = "TaxGroup"; //$NON-NLS-1$
	public static final String Terminal = "Terminal"; //$NON-NLS-1$
	public static final String TerminalType = "TerminalType"; //$NON-NLS-1$
	public static final String Ticket = "Ticket"; //$NON-NLS-1$
	public static final String User = "User"; //$NON-NLS-1$
	public static final String UserType = "UserType"; //$NON-NLS-1$
	public static final String PrinterGroup = "PrinterGroup"; //$NON-NLS-1$
	public static final String VirtualPrinter = "VirtualPrinter"; //$NON-NLS-1$
	public static final String VoidReason = "VoidReason"; //$NON-NLS-1$
	public static final String ReportGroup = "ReportGroup"; //$NON-NLS-1$
	public static final String ShopTableType = "ShopTableType"; //$NON-NLS-1$
	public static final String ActionHistory = "ActionHistory"; //$NON-NLS-1$
	public static final String VoidItem = "VoidItem"; //$NON-NLS-1$
	public static final String Recipe = "Recepie"; //$NON-NLS-1$
	public static final String PurchaseOrder = "PurchaseOrder"; //$NON-NLS-1$
	public static final String StockCount = "StockCount"; //$NON-NLS-1$
	public static final String ShopFloorTemplate = "ShopFloorTemplate"; //$NON-NLS-1$
	public static final String CronJob = "CronJob"; //$NON-NLS-1$
	public static final String Gratuity = "Gratuity"; //$NON-NLS-1$
	public static final String SlideShowImage = "SlideShowImage"; //$NON-NLS-1$
	public static final String DeletedData = "DeletedData"; //$NON-NLS-1$

	public static List<DataSyncInfo> getSyncModelClasses(String outletId) {
		List<DataSyncInfo> beanClasses = new ArrayList<>();
		beanClasses.add(new DataSyncInfo(Address.class, Address));
		beanClasses.add(new DataSyncInfo(Outlet.class, Outlet));
		beanClasses.add(new DataSyncInfo(StoreSession.class, StoreSession, outletId));
		beanClasses.add(new DataSyncInfo(ImageResource.class, ImageResource));
		beanClasses.add(new DataSyncInfo(Currency.class, Currency, outletId));
		beanClasses.add(new DataSyncInfo(Shift.class, Shift, outletId));
		beanClasses.add(new DataSyncInfo(CashDrawer.class, CashDrawer, outletId));
		beanClasses.add(new DataSyncInfo(Terminal.class, Terminal, outletId));
		beanClasses.add(new DataSyncInfo(TaxGroup.class, TaxGroup, outletId));
		beanClasses.add(new DataSyncInfo(Tax.class, Tax, outletId));
		beanClasses.add(new DataSyncInfo(OrderType.class, OrderType, outletId));
		beanClasses.add(new DataSyncInfo(Department.class, Department));
		beanClasses.add(new DataSyncInfo(UserType.class, UserType));
		beanClasses.add(new DataSyncInfo(User.class, User, outletId));
		beanClasses.add(new DataSyncInfo(AttendenceHistory.class, AttendenceHistory, outletId)); //rs
		beanClasses.add(new DataSyncInfo(BalanceUpdateTransaction.class, BalanceUpdateTransaction));
		beanClasses.add(new DataSyncInfo(Customer.class, Customer));
		beanClasses.add(new DataSyncInfo(Multiplier.class, Multiplier));
		beanClasses.add(new DataSyncInfo(MenuItemSize.class, MenuItemSize));
		beanClasses.add(new DataSyncInfo(PriceTable.class, PriceTable, outletId));//rs
		beanClasses.add(new DataSyncInfo(PriceRule.class, PriceRule, outletId));//rs
		beanClasses.add(new DataSyncInfo(MenuModifier.class, MenuModifier));
		beanClasses.add(new DataSyncInfo(ModifierGroup.class, ModifierGroup));
		beanClasses.add(new DataSyncInfo(MenuCategory.class, MenuCategory));
		beanClasses.add(new DataSyncInfo(MenuGroup.class, MenuGroup));
		beanClasses.add(new DataSyncInfo(AttributeGroup.class, AttributeGroup));
		beanClasses.add(new DataSyncInfo(Attribute.class, Attribute));
		beanClasses.add(new DataSyncInfo(CookingInstruction.class, CookingInstruction));
		beanClasses.add(new DataSyncInfo(InventoryUnitGroup.class, InventoryUnitGroup));
		beanClasses.add(new DataSyncInfo(InventoryUnit.class, InventoryUnit));
		beanClasses.add(new DataSyncInfo(PackagingUnit.class, PackagingUnit));
		beanClasses.add(new DataSyncInfo(InventoryLocation.class, InventoryLocation));
		beanClasses.add(new DataSyncInfo(MenuItem.class, MenuItem));
		beanClasses.add(new DataSyncInfo(InventoryVendor.class, InventoryVendor));
		beanClasses.add(new DataSyncInfo(InventoryVendorItems.class, InventoryVendorItems));
		beanClasses.add(new DataSyncInfo(InventoryClosingBalance.class, InventoryClosingBalance, outletId));//rs
		beanClasses.add(new DataSyncInfo(BookingInfo.class, BookingInfo, outletId));
		beanClasses.add(new DataSyncInfo(Ticket.class, Ticket, outletId));
		beanClasses.add(new DataSyncInfo(CustomerGroup.class, CustomerGroup));
		beanClasses.add(new DataSyncInfo(CustomPayment.class, CustomPayment, outletId));
		beanClasses.add(new DataSyncInfo(DeclaredTips.class, DeclaredTips));
		beanClasses.add(new DataSyncInfo(DeliveryAddress.class, DeliveryAddress));
		beanClasses.add(new DataSyncInfo(DeliveryCharge.class, DeliveryCharge, outletId));
		beanClasses.add(new DataSyncInfo(DeliveryInstruction.class, DeliveryInstruction));//rs
		beanClasses.add(new DataSyncInfo(Discount.class, Discount));
		beanClasses.add(new DataSyncInfo(GiftCard.class, GiftCard));
		beanClasses.add(new DataSyncInfo(SalesArea.class, SalesArea));
		beanClasses.add(new DataSyncInfo(TerminalType.class, TerminalType, outletId));//rs
		beanClasses.add(new DataSyncInfo(InventoryTransaction.class, InventoryTransaction, outletId));
		beanClasses.add(new DataSyncInfo(PrinterGroup.class, PrinterGroup));
		beanClasses.add(new DataSyncInfo(VirtualPrinter.class, VirtualPrinter));
		beanClasses.add(new DataSyncInfo(VoidReason.class, VoidReason));
		beanClasses.add(new DataSyncInfo(ReportGroup.class, ReportGroup));
		beanClasses.add(new DataSyncInfo(ActionHistory.class, ActionHistory, outletId));
		beanClasses.add(new DataSyncInfo(VoidItem.class, VoidItem, outletId));
		beanClasses.add(new DataSyncInfo(Recepie.class, Recipe));
		beanClasses.add(new DataSyncInfo(PurchaseOrder.class, PurchaseOrder, outletId));
		beanClasses.add(new DataSyncInfo(StockCount.class, StockCount, outletId));
		beanClasses.add(new DataSyncInfo(CronJob.class, CronJob));
		beanClasses.add(new DataSyncInfo(Gratuity.class, Gratuity, outletId));
		beanClasses.add(new DataSyncInfo(GratuityPaymentHistory.class, GratuityPaymentHistory, outletId));//rs
		beanClasses.add(new DataSyncInfo(SlideShowImage.class, SlideShowImage));
		return beanClasses;
	}
	
	public static List<String> getOutletRelatedModelClasses() {
		List<String> beanClasses = new ArrayList<>();
		beanClasses.add(ActionHistory);
		beanClasses.add(AttendenceHistory);
		beanClasses.add(BookingInfo);
		beanClasses.add(CashDrawer);
		beanClasses.add(Gratuity);
		beanClasses.add(InventoryClosingBalance);
		beanClasses.add(InventoryLocation);
		beanClasses.add(InventoryTransaction);
		beanClasses.add(InventoryVendor);
		beanClasses.add(InventoryVendorItems);
		beanClasses.add(PosTransaction.REF);
		beanClasses.add(PriceRule);
		beanClasses.add(PriceTable);
		beanClasses.add(PurchaseOrder);
		beanClasses.add(ShopFloor);
		beanClasses.add(ShopTable);
		beanClasses.add(StockCount);
		beanClasses.add(StoreSession);
		beanClasses.add(Terminal);
		beanClasses.add(Ticket);
		beanClasses.add(User);

		return beanClasses;
	}
}
