package com.floreantpos.util;

import org.apache.commons.lang.StringUtils;

public enum CashRoundingRule {

	_NOROUNDING("No Rounding", ""),
	_05Interval("Rounding with 0.05 interval", "Exp: 1.02 will be rounded to 1.00, 1.06 will be rounded to 1.05"), 
	_10Interval("Rounding with 0.10 interval", "Exp: 1.02 will be rounded to 1.0, 1.06 will be rounded to 1.1"), 
	_25Interval("Rounding with 0.25 interval", "Exp: 1.02 will be rounded to 1.00, 1.26 will be rounded to 1.25"), 
	_50Interval("Rounding with 0.50 interval", "Exp: 1.02 will be rounded to 1.00, 1.26 will be rounded to 1.5"), 
	_1Interval("Rounding with  1.0 interval",  "Exp: 1.02 will be rounded to 1.0, 1.5 will be rounded to 2.0");

	private String displayString;
	private String exampleString;

	private CashRoundingRule(String displayString, String exampleString) {
		this.displayString = displayString;
		this.exampleString = exampleString;
	}

	public String getDisplayString() {
		return displayString;
	}

	public String getExampleString() {
		return exampleString;
	}

	public static CashRoundingRule fromDisplayString(String displayString) {
		CashRoundingRule[] cashRoundingtypes = values();
		for (CashRoundingRule roundingType : cashRoundingtypes) {
			if (roundingType.getDisplayString().equals(displayString)) {
				return roundingType;
			}
		}
		return _NOROUNDING;
	}

	public static double round(CashRoundingRule cashRounding, double value) {

		switch (cashRounding) {
			case _10Interval:
				return tenCentRound(value);
			case _05Interval:
				return fiveCentRound(value);
			case _25Interval:
				return twentyFiveCentRound(value);
			case _50Interval:
				return fiftyCentRound(value);
			case _1Interval:
				return fullRound(value);
			default:
				return value;
		}
	}

	public static double fiveCentRound(double value) {
		return Math.round(value * 100.0 / 5.0) * 5.0 / 100.0;
	}

	public static double tenCentRound(double value) {
		return Math.round(value * 10.0) / 10.0;
	}

	public static double twentyFiveCentRound(double value) {
		return Math.round(value * 4.0) / 4.0;
	}

	public static double fiftyCentRound(double value) {
		return Math.round(value * 2.0) / 2.0;
	}

	public static double fullRound(double value) {
		return Math.round(value);
	}

	@Override
	public String toString() {
		if (StringUtils.isBlank(exampleString)) {
			return displayString;
		}
		return displayString + " (" + exampleString + ")";
	}

}
