package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.Requisition;
import com.floreantpos.swing.PaginationSupport;

public class RequisitionDAO extends BaseRequisitionDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public RequisitionDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	@Override
	protected void delete(Object obj, Session s) {
		if (obj instanceof Requisition) {
			Requisition purchaseOrder = (Requisition) obj;
			purchaseOrder.setDeleted(Boolean.TRUE);
			super.update(purchaseOrder, s);
		}
		else {
			super.delete(obj, s);
		}
	}

	public void loadRequisions(PaginationSupport dataModel, Date fromDate, Date toDate, String requisitioId) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(Requisition.class);
			addDeletedFilter(criteria);

			if (StringUtils.isNotBlank(requisitioId)) {
				criteria.add(Restrictions.eq(Requisition.PROP_ID, requisitioId));
			}
			if (fromDate != null && toDate != null) {
				criteria.add(Restrictions.between(Requisition.PROP_CREATE_DATE, fromDate, toDate));
			}

			dataModel.setNumRows(rowCount(criteria));

			criteria.setFirstResult(dataModel.getCurrentRowIndex());
			criteria.setMaxResults(dataModel.getPageSize());

			criteria.addOrder(Order.desc(Requisition.PROP_CREATE_DATE));

			dataModel.setRows(criteria.list());
		}
	}

}