package com.floreantpos.print;

import java.util.HashMap;

import javax.swing.JPanel;

import com.floreantpos.constants.AppConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;

public abstract class ReceiptPrintServiceProvider {

	public abstract void printTicket(Ticket ticket, HashMap map, String deviceName) throws Exception;

	public abstract void printTransaction(Ticket ticket, HashMap map, PosTransaction transaction, String deviceName) throws Exception;

	public abstract void printRefundTicket(Ticket ticket, HashMap map, String deviceName) throws Exception;

	public abstract void printVoidTicket(Ticket ticket, HashMap map, String receiptPrinter) throws Exception;

	public abstract void printKitchenTicket(KitchenTicket kitchenTicket, HashMap map, Ticket ticket, String printerName, String deviceName) throws Exception;

	public abstract void printVoidKitchenTicket(KitchenTicket kitchenTicket, HashMap map, String printerName, String deviceName) throws Exception;

	public abstract void rendererTicketReceipt(Ticket ticket, JPanel reportPanel) throws Exception;

	public abstract void rendererPosTransactionReceipt(PosTransaction transaction, JPanel reportPanel) throws Exception;

	public abstract void rendererKitchenReceipt(Ticket ticket, JPanel reportPanel) throws Exception;

	private static ReceiptPrintServiceProvider instance;

	public static ReceiptPrintServiceProvider get() {
		if (instance == null) {
			if (Application.getInstance().getTerminal().getProperty(AppConstants.RECEIPT_PRINT_SYSTEM, AppConstants.RECEIPT_JASPER)
					.equals(AppConstants.RECEIPT_ESC)) {
				instance = new EscPosPrintService();
				return instance;
			}
			instance = new JasperPrintService();
		}
		return instance;
	}

	public static void set(ReceiptPrintServiceProvider dataProvider) {
		ReceiptPrintServiceProvider.instance = dataProvider;
	}

	public abstract void testPrinter(HashMap<String, Object> map, String deviceName) throws Exception;

}
