package com.floreantpos.gsonAdapter;

import java.lang.reflect.Type;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Specimen;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.SpecimenDAO;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;

public class MenuItemAdapter implements JsonSerializer<MenuItem> {

	@Override
	public JsonElement serialize(MenuItem src, Type typeOfSrc, JsonSerializationContext context) {
		JsonObject jsonObject = new JsonObject();

		jsonObject.addProperty(MenuItem.PROP_ID, src.getId());
		jsonObject.addProperty(MenuItem.PROP_NAME, src.getName());
		jsonObject.addProperty(MenuItem.PROP_DESCRIPTION, src.getDescription());
		jsonObject.addProperty(MenuItem.PROP_PRICE, src.getPrice());
		jsonObject.addProperty("Cost/BasePrice", src.getCost());
		jsonObject.addProperty(MenuItem.PROP_BARCODE, src.getBarcode());
		jsonObject.addProperty(MenuItem.PROP_SKU, src.getSku());
		jsonObject.addProperty(MenuItem.PROP_UNIT_NAME, src.getUnitName());
		jsonObject.addProperty(MenuItem.PROP_MENU_CATEGORY_NAME, src.getMenuCategoryName());
		jsonObject.addProperty(MenuItem.PROP_MENU_GROUP_NAME, src.getMenuGroupName());
		TaxGroup taxGroup = src.getTaxGroup();
		if (taxGroup != null) {
			jsonObject.addProperty("TaxGroup", taxGroup.toString());
		}
		else {
			jsonObject.addProperty("TaxGroup", "");
		}

		jsonObject.addProperty(MenuItem.PROP_VISIBLE, src.getVisible());

		if (!src.isInventoryItem()) {
			jsonObject.addProperty("UrgentPrice", src.getUrgentPrice());
			String specimenId = src.getSpecimenId();
			if (StringUtils.isNotBlank(specimenId)) {
				Specimen specimen = SpecimenDAO.getInstance().get(specimenId);
				if (specimen != null) {
					String name = specimen.getName();
					jsonObject.addProperty("Specimen", name);
				}
			}
			else {
				jsonObject.addProperty("Specimen", "");
			}
			jsonObject.addProperty("DeliveryTime", src.getDeliveryTime());
			jsonObject.addProperty("DeliveryTimeType", src.getDeliveryTimeType());
			jsonObject.addProperty("ArgentDeli.Time", src.getUrgentDeliveryTime());
			jsonObject.addProperty("ArgentDeli.TimeType", src.getUrgentDeliveryTimeType());
			jsonObject.addProperty("RequiresDoctor", src.isLabDoctorRequired());
			jsonObject.addProperty("PriceIncludesDoctorFee", src.isPriceIncludesDoctorFee());
			jsonObject.addProperty("DoctorFee", src.getLabDoctorFee());
		}

		if (src.isInventoryItem()) {
			jsonObject.addProperty(MenuItem.PROP_INVENTORY_ITEM, src.isInventoryItem());
			jsonObject.addProperty(MenuItem.PROP_RAW_MATERIAL, src.isRawMaterial());
			jsonObject.addProperty(MenuItem.PROP_EDITABLE_PRICE, src.isEditablePrice());
		}

		return jsonObject;
	}

}
