/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseCreditCardTransaction;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CreditCardTransaction extends BaseCreditCardTransaction {
	private static final long serialVersionUID = 1L;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public CreditCardTransaction () {
    }

	/**
	 * Constructor for primary key
	 */
	public CreditCardTransaction (java.lang.String id) {
		super(id);
	}

	/**
	 * Constructor for required fields
	 */
	public CreditCardTransaction (
		java.lang.String id,
		java.lang.String transactionType,
		java.lang.String paymentTypeString) {

		super (
			id,
			transactionType,
			paymentTypeString);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public String getTransactionReason() {
		return TransactionReason.SALES.name();
	}
}