package com.floreantpos.model;

import java.lang.reflect.Type;
import java.util.List;

import com.floreantpos.model.base.BaseDischargeRecord;
import com.floreantpos.util.GsonUtil;
import com.google.gson.reflect.TypeToken;

public class DischargeRecord extends BaseDischargeRecord {
	private static final long serialVersionUID = 1L;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public DischargeRecord() {
	}

	/**
	 * Constructor for primary key
	 */
	public DischargeRecord(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public List<DoctorVisitDiagnosisItem> getDiagnosisItems() {
		return GsonUtil.convertJSONToList(getDiagnosis(), DoctorVisitDiagnosisItem.class);
	}

	public void putDiagnosisItems(List<DoctorVisitDiagnosisItem> diagnosisItems) {
		if (diagnosisItems != null) {
			for (DoctorVisitDiagnosisItem doctorVisitDiagnosisItem : diagnosisItems) {
				doctorVisitDiagnosisItem.setDoctorVisit(null);
			}
		}
		setDiagnosis(GsonUtil.createGson().toJson(diagnosisItems));
	}

	public List<DoctorVisitMedicineItem> getMedicationItems() {
		Type listType = TypeToken.getParameterized(List.class, DoctorVisitMedicineItem.class).getType();
		return GsonUtil.createGson().fromJson(getMedications(), listType);
	}

	public void putMedicationItems(List<DoctorVisitMedicineItem> medicationItems) {
		if (medicationItems != null) {
			for (DoctorVisitMedicineItem medicationItem : medicationItems) {
				medicationItem.setDoctorVisit(null);
			}
		}
		setMedications(GsonUtil.createGson().toJson(medicationItems));
	}

	public List<String> getInstructionList() {
		return GsonUtil.convertJSONToList(getInstruction(), String.class);
	}

	public void putInstructionList(List<String> instructions) {
		setInstruction(GsonUtil.createGson().toJson(instructions));
	}

	public List<String> getProblemList() {
		return GsonUtil.convertJSONToList(getProblems(), String.class);
	}

	public void putProblemList(List<String> problems) {
		setProblems(GsonUtil.createGson().toJson(problems));
	}
}