package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

public enum MedicationShift {
	MORNING("Morning"), NOON("Noon"), AFTERNOON("Afternoon"), NIGHT("Night");

	private String displayName;

	MedicationShift(String displayName) {
		this.displayName = displayName;
	}

	@Override
	public String toString() {
		return displayName;
	}

	public static MedicationShift fromString(String timeOfDayName) {
		if (StringUtils.isBlank(timeOfDayName)) {
			return null;
		}
		MedicationShift[] timeOfDays = values();
		for (MedicationShift timeOfDay : timeOfDays) {
			if (timeOfDay.name().equalsIgnoreCase(timeOfDayName)) {
				return timeOfDay;
			}
			else if (timeOfDay.name().equalsIgnoreCase(timeOfDayName.replaceAll(" ", ""))) { //$NON-NLS-1$ //$NON-NLS-2$
				return timeOfDay;
			}
		}
		return null;
	}
}
