package com.floreantpos.model;

public enum OTComplicationSeverity {
	//@formatter:off
	 	NORMAL("Normal", "No complications detected; procedure completed successfully"),
		MILD("Mild", "Superficial wound infection treated with antibiotics"),
	    MODERATE("Moderate", "Reoperation required for bleeding control"),
	    SEVERE("Severe", "Cardiac arrest during recovery");
		;
		//@formatter:on

	private String severityLevel; // Name of the severity level
	private String description; // Description of the complication

	private OTComplicationSeverity(String severityLevel, String description) {
		this.severityLevel = severityLevel;
		this.description = description;
	}

	public String getSeverityLevel() {
		return severityLevel;
	}

	public String getDescription() {
		return description;
	}

	public static OTComplicationSeverity fromNameString(String name) {
		OTComplicationSeverity[] statusList = values();
		for (OTComplicationSeverity status : statusList) {
			if (status.name().equals(name)) {
				return status;
			}
		}
		return NORMAL;
	}

	@Override
	public String toString() {
		return getSeverityLevel();
	}

}
