package com.floreantpos.model;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;

import com.floreantpos.model.base.BaseSequenceNumber;

public class SequenceNumber extends BaseSequenceNumber {
	private static final long serialVersionUID = 1L;

	public static final String OUTDOOR_TICKET_TOKEN = "OUTDOOR_TICKET_TOKEN_NUMBER"; //$NON-NLS-1$
	public static final String TICKET_TOKEN = "TICKET_TOKEN_NUMBER"; //$NON-NLS-1$
	public static final String TICKET_SEQUENCE_NUMBER = "TICKET_SEQUENCE_NUMBER"; //$NON-NLS-1$
	public static final String OUTDOOR_TICKET_SEQUENCE_NUMBER = "OUTDOOR_TICKET_SEQUENCE_NUMBER"; //$NON-NLS-1$
	public static final String PRESCRIPTION_SEQUENCE_NUMBER = "PRESCRIPTION_SEQUENCE_NUMBER"; //$NON-NLS-1$
	public static final String BOOKING_SEQUENCE_NUMBER = "BOOKING_SEQUENCE_NUMBER"; //$NON-NLS-1$
	public static final String LAB_TEST_SEQUENCE_NUMBER = "LAB_TEST_SEQUENCE_NUMBER"; //$NON-NLS-1$
	public static final String PROJECT_ID_SEQUENCE_NUMBER = "PROJECT_ID_SEQUENCE_NUMBER"; //$NON-NLS-1$
	public static final String REQUISITION_ID_SEQUENCE_NUMBER = "REQUISITION_ID_SEQUENCE_NUMBER"; //$NON-NLS-1$
	public static final String USER_ID_SEQUENCE_NUMBER = "USER_ID_SEQUENCE_NUMBER"; //$NON-NLS-1$
	public static final String SEQ_LEDGER_ENTRY = "ledger_entry"; //$NON-NLS-1$
	public static final String POS_TRANSACTION_BATCH_NO = "POS_TRANSACTION_BATCH_NO"; //$NON-NLS-1$
	public static final String PAYOUT_BATCH_NO = "PAYOUT_BATCH_NO"; //$NON-NLS-1$
	public static final String EXPENSES_BATCH_NO = "EXPENSES_BATCH_NO"; //$NON-NLS-1$
	public static final String PROP_REFERENCE_NO = "REFERENCE_NO"; //$NON-NLS-1$
	public static final String QUOTATION_SEQUENCE_NUMBER = "QUOTATION_SEQUENCE_NUMBER"; //$NON-NLS-1$
	public static final String DEFAULT_SEQUENCE_NUMBER = "DEFAULT_SEQUENCE_NUMBER"; //$NON-NLS-1$

	public static SimpleDateFormat yearMonthDayFormat = new SimpleDateFormat("yyMMdd"); //$NON-NLS-1$
	public static SimpleDateFormat yearAndWeekfFormat = new SimpleDateFormat("yyww"); //$NON-NLS-1$
	public static DecimalFormat threeDigitDecimalFormat = new DecimalFormat("000"); //$NON-NLS-1$

	static {
		yearMonthDayFormat.setTimeZone(TimeZone.getTimeZone("BST"));
		yearAndWeekfFormat.setTimeZone(TimeZone.getTimeZone("BST"));
	}

	public SequenceNumber() {
	}

	public SequenceNumber(java.lang.String id) {
		super(id);
	}

	public SequenceNumber(java.lang.String id, Integer nextReference) {
		super(id);
		setNextSequenceNumber(nextReference);
	}

}