package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the ACTION_HISTORY table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="ACTION_HISTORY"
 */

public abstract class BaseActionHistory  implements Comparable, Serializable {

	public static String REF = "ActionHistory"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_ACTION_TYPE = "actionType"; //$NON-NLS-1$
	public static String PROP_DESCRIPTION = "description"; //$NON-NLS-1$
	public static String PROP_SHORT_DESCRIPTION = "shortDescription"; //$NON-NLS-1$
	public static String PROP_TRANSACTION_ID = "transactionId"; //$NON-NLS-1$
	public static String PROP_ACTION_TIME = "actionTime"; //$NON-NLS-1$
	public static String PROP_ACTION_NAME = "actionName"; //$NON-NLS-1$
	public static String PROP_PERFORMER = "performer"; //$NON-NLS-1$
	public static String PROP_TICKET_ID = "ticketId"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_EVENT_TIME = "eventTime"; //$NON-NLS-1$
	public static String PROP_TERMINAL_ID = "terminalId"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$


	// constructors
	public BaseActionHistory () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseActionHistory (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.util.Date actionTime;
				private java.util.Date eventTime;
				private java.lang.String actionName;
				private java.lang.String actionType;
				private java.lang.String description;
				private java.lang.String shortDescription;
				private java.lang.String ticketId;
				private java.lang.String transactionId;
				private java.lang.String outletId;
				private java.lang.String terminalId;
	
	// many to one
	private com.floreantpos.model.User performer;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: ACTION_TIME
	 */

	public java.util.Date getActionTime () {
			return actionTime;
	}



	/**
	 * Set the value related to the column: ACTION_TIME
	 * @param actionTime the ACTION_TIME value
	 */
			public void setActionTime (java.util.Date actionTime) {
			this.actionTime = actionTime;
	}



	/**
	 * Return the value associated with the column: EVENT_TIME
	 */

	public java.util.Date getEventTime () {
			return eventTime;
	}



	/**
	 * Set the value related to the column: EVENT_TIME
	 * @param eventTime the EVENT_TIME value
	 */
			public void setEventTime (java.util.Date eventTime) {
			this.eventTime = eventTime;
	}



	/**
	 * Return the value associated with the column: ACTION_NAME
	 */

	public java.lang.String getActionName () {
			return actionName;
	}



	/**
	 * Set the value related to the column: ACTION_NAME
	 * @param actionName the ACTION_NAME value
	 */
			public void setActionName (java.lang.String actionName) {
			this.actionName = actionName;
	}



	/**
	 * Return the value associated with the column: ACTION_TYPE
	 */

	public java.lang.String getActionType () {
			return actionType;
	}



	/**
	 * Set the value related to the column: ACTION_TYPE
	 * @param actionType the ACTION_TYPE value
	 */
			public void setActionType (java.lang.String actionType) {
			this.actionType = actionType;
	}



	/**
	 * Return the value associated with the column: DESCRIPTION
	 */

	public java.lang.String getDescription () {
			return description;
	}



	/**
	 * Set the value related to the column: DESCRIPTION
	 * @param description the DESCRIPTION value
	 */
			public void setDescription (java.lang.String description) {
			this.description = description;
	}



	/**
	 * Return the value associated with the column: SHORT_DESCRIPTION
	 */

	public java.lang.String getShortDescription () {
			return shortDescription;
	}



	/**
	 * Set the value related to the column: SHORT_DESCRIPTION
	 * @param shortDescription the SHORT_DESCRIPTION value
	 */
			public void setShortDescription (java.lang.String shortDescription) {
			this.shortDescription = shortDescription;
	}



	/**
	 * Return the value associated with the column: TICKET_ID
	 */

	public java.lang.String getTicketId () {
			return ticketId;
	}



	/**
	 * Set the value related to the column: TICKET_ID
	 * @param ticketId the TICKET_ID value
	 */
			public void setTicketId (java.lang.String ticketId) {
			this.ticketId = ticketId;
	}



	/**
	 * Return the value associated with the column: TRANSACTION_ID
	 */

	public java.lang.String getTransactionId () {
			return transactionId;
	}



	/**
	 * Set the value related to the column: TRANSACTION_ID
	 * @param transactionId the TRANSACTION_ID value
	 */
			public void setTransactionId (java.lang.String transactionId) {
			this.transactionId = transactionId;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: TERMINAL_ID
	 */

	public java.lang.String getTerminalId () {
			return terminalId;
	}



	/**
	 * Set the value related to the column: TERMINAL_ID
	 * @param terminalId the TERMINAL_ID value
	 */
			public void setTerminalId (java.lang.String terminalId) {
			this.terminalId = terminalId;
	}



	/**
	 * Return the value associated with the column: PERFORMER_OUTLET_ID
	 */

	public com.floreantpos.model.User getPerformer () {
			return performer;
	}



	/**
	 * Set the value related to the column: PERFORMER_OUTLET_ID
	 * @param performer the PERFORMER_OUTLET_ID value
	 */
			public void setPerformer (com.floreantpos.model.User performer) {
			this.performer = performer;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.ActionHistory)) return false;
		else {
			com.floreantpos.model.ActionHistory actionHistory = (com.floreantpos.model.ActionHistory) obj;
			if (null == this.getId() || null == actionHistory.getId()) return this == obj;
			else return (this.getId().equals(actionHistory.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}