package com.floreantpos.util;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Date;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.IdentifierGenerator;

import com.floreantpos.PosLog;
import com.floreantpos.model.SequenceNumber;
import com.floreantpos.model.dao.PrescriptionDAO;
import com.floreantpos.model.dao.SequenceNumberDAO;
import com.floreantpos.model.util.DataProvider;

public class PrescriptionIdGenerator implements IdentifierGenerator {
	@Override
	public Serializable generate(SessionImplementor session, Object object) throws HibernateException {
		Class<? extends Object> clazz = object.getClass();
		Serializable generatedId = null;
		try {
			Method method = clazz.getMethod("getId", (Class<?>[]) null); //$NON-NLS-1$
			if (method != null) {
				Object id = method.invoke(object, (Object[]) null);
				if (id != null) {
					generatedId = (Serializable) id;
				}
			}

			if (generatedId == null) {
				generatedId = generatePrescriptionId((Session) session, DataProvider.get().getOutletId());
			}
		} catch (Exception e) {
			PosLog.error(PrescriptionIdGenerator.class, e);
		}

		return generatedId;
	}

	public static String generatePrescriptionId(String outletId) {
		try (Session session = PrescriptionDAO.getInstance().createNewSession()) {
			return generatePrescriptionId(session, outletId);
		}
	}

	public static String generatePrescriptionId(Session session, String outletId) {
		if (StringUtils.isBlank(outletId)) {
			outletId = DataProvider.get().getOutletId();
		}
		String prefix = SequenceNumber.yearMonthDayFormat.format(new Date());
		String prescription = prefix + SequenceNumber.threeDigitDecimalFormat
				.format(SequenceNumberDAO.getInstance().getNextSequenceNumber(SequenceNumber.PRESCRIPTION_SEQUENCE_NUMBER, prefix));
		while (PrescriptionDAO.getInstance().get(prescription, session) != null) {
			prescription = prefix + SequenceNumber.threeDigitDecimalFormat
					.format(SequenceNumberDAO.getInstance().getNextSequenceNumber(SequenceNumber.PRESCRIPTION_SEQUENCE_NUMBER, prefix));
		}
		return prescription;
	}
}
