package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the KITCHEN_TICKET table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="KITCHEN_TICKET"
 */

public abstract class BaseKitchenTicket  implements Comparable, Serializable {

	public static String REF = "KitchenTicket"; //$NON-NLS-1$
	public static String PROP_STATUS = "status"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_PRINTER_GROUP = "printerGroup"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_CREATE_DATE = "createDate"; //$NON-NLS-1$
	public static String PROP_TOKEN_NO = "tokenNo"; //$NON-NLS-1$
	public static String PROP_TICKET_ID = "ticketId"; //$NON-NLS-1$
	public static String PROP_PRINTER_NAME = "printerName"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_SERVER_NAME = "serverName"; //$NON-NLS-1$
	public static String PROP_ORDER_TYPE_ID = "orderTypeId"; //$NON-NLS-1$
	public static String PROP_SEQUENCE_NUMBER = "sequenceNumber"; //$NON-NLS-1$
	public static String PROP_CLOSING_DATE = "closingDate"; //$NON-NLS-1$
	public static String PROP_SHOW_ON_KIT_DISPLAY = "showOnKitDisplay"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_VOIDED = "voided"; //$NON-NLS-1$


	// constructors
	public BaseKitchenTicket () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseKitchenTicket (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String ticketId;
				private java.lang.Integer tokenNo;
				private java.util.Date createDate;
				private java.util.Date closingDate;
				private java.lang.Boolean voided;
				private java.lang.Integer sequenceNumber;
				private java.lang.String status;
				private java.lang.String serverName;
				private java.lang.String orderTypeId;
				private java.lang.String outletId;
				private java.lang.String printerName;
				private java.lang.Boolean showOnKitDisplay;
				private java.lang.String properties;
	
	// many to one
	private com.floreantpos.model.PrinterGroup printerGroup;

	// collections
	private java.util.List<Integer> tableNumbers;
	private java.util.List<com.floreantpos.model.KitchenTicketItem> ticketItems;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: TICKET_ID
	 */

	public java.lang.String getTicketId () {
			return ticketId;
	}



	/**
	 * Set the value related to the column: TICKET_ID
	 * @param ticketId the TICKET_ID value
	 */
			public void setTicketId (java.lang.String ticketId) {
			this.ticketId = ticketId;
	}



	/**
	 * Return the value associated with the column: TOKEN_NO
	 */

	public java.lang.Integer getTokenNo () {
						return tokenNo == null ? Integer.valueOf(0) : tokenNo;
		}



	/**
	 * Set the value related to the column: TOKEN_NO
	 * @param tokenNo the TOKEN_NO value
	 */
			public void setTokenNo (java.lang.Integer tokenNo) {
			this.tokenNo = tokenNo;
	}



	/**
	 * Return the value associated with the column: CREATE_DATE
	 */

	public java.util.Date getCreateDate () {
			return createDate;
	}



	/**
	 * Set the value related to the column: CREATE_DATE
	 * @param createDate the CREATE_DATE value
	 */
			public void setCreateDate (java.util.Date createDate) {
			this.createDate = createDate;
	}



	/**
	 * Return the value associated with the column: CLOSE_DATE
	 */

	public java.util.Date getClosingDate () {
			return closingDate;
	}



	/**
	 * Set the value related to the column: CLOSE_DATE
	 * @param closingDate the CLOSE_DATE value
	 */
			public void setClosingDate (java.util.Date closingDate) {
			this.closingDate = closingDate;
	}



	/**
	 * Return the value associated with the column: VOIDED
	 */

	public java.lang.Boolean isVoided () {
					return voided == null ? Boolean.FALSE : voided;
		}

	public java.lang.Boolean getVoided () {
				return voided == null ? Boolean.FALSE : voided;
			}


	/**
	 * Set the value related to the column: VOIDED
	 * @param voided the VOIDED value
	 */
			public void setVoided (java.lang.Boolean voided) {
			this.voided = voided;
	}



	/**
	 * Return the value associated with the column: SEQUENCE_NUMBER
	 */

	public java.lang.Integer getSequenceNumber () {
						return sequenceNumber == null ? Integer.valueOf(0) : sequenceNumber;
		}



	/**
	 * Set the value related to the column: SEQUENCE_NUMBER
	 * @param sequenceNumber the SEQUENCE_NUMBER value
	 */
			public void setSequenceNumber (java.lang.Integer sequenceNumber) {
			this.sequenceNumber = sequenceNumber;
	}



	/**
	 * Return the value associated with the column: STATUS
	 */

	public java.lang.String getStatus () {
			return status;
	}



	/**
	 * Set the value related to the column: STATUS
	 * @param status the STATUS value
	 */
			public void setStatus (java.lang.String status) {
			this.status = status;
	}



	/**
	 * Return the value associated with the column: SERVER_NAME
	 */

	public java.lang.String getServerName () {
			return serverName;
	}



	/**
	 * Set the value related to the column: SERVER_NAME
	 * @param serverName the SERVER_NAME value
	 */
			public void setServerName (java.lang.String serverName) {
			this.serverName = serverName;
	}



	/**
	 * Return the value associated with the column: ORDER_TYPE
	 */

	public java.lang.String getOrderTypeId () {
			return orderTypeId;
	}



	/**
	 * Set the value related to the column: ORDER_TYPE
	 * @param orderTypeId the ORDER_TYPE value
	 */
			public void setOrderTypeId (java.lang.String orderTypeId) {
			this.orderTypeId = orderTypeId;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: PRINTER_NAME
	 */

	public java.lang.String getPrinterName () {
			return printerName;
	}



	/**
	 * Set the value related to the column: PRINTER_NAME
	 * @param printerName the PRINTER_NAME value
	 */
			public void setPrinterName (java.lang.String printerName) {
			this.printerName = printerName;
	}



	/**
	 * Return the value associated with the column: SHOW_ON_KIT_DISPLAY
	 */

	public java.lang.Boolean isShowOnKitDisplay () {
						return showOnKitDisplay == null ? Boolean.valueOf(true) : showOnKitDisplay;
			}

	public java.lang.Boolean getShowOnKitDisplay () {
					return showOnKitDisplay == null ? Boolean.valueOf(true) : showOnKitDisplay;
			}


	/**
	 * Set the value related to the column: SHOW_ON_KIT_DISPLAY
	 * @param showOnKitDisplay the SHOW_ON_KIT_DISPLAY value
	 */
			public void setShowOnKitDisplay (java.lang.Boolean showOnKitDisplay) {
			this.showOnKitDisplay = showOnKitDisplay;
	}


	/**
	 * Custom property
	 */
	public static String getShowOnKitDisplayDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: PG_ID
	 */

	public com.floreantpos.model.PrinterGroup getPrinterGroup () {
			return printerGroup;
	}



	/**
	 * Set the value related to the column: PG_ID
	 * @param printerGroup the PG_ID value
	 */
			public void setPrinterGroup (com.floreantpos.model.PrinterGroup printerGroup) {
			this.printerGroup = printerGroup;
	}



	/**
	 * Return the value associated with the column: tableNumbers
	 */

	public java.util.List<Integer> getTableNumbers () {
			return tableNumbers;
	}



	/**
	 * Set the value related to the column: tableNumbers
	 * @param tableNumbers the tableNumbers value
	 */
			public void setTableNumbers (java.util.List<Integer> tableNumbers) {
			this.tableNumbers = tableNumbers;
	}



	/**
	 * Return the value associated with the column: ticketItems
	 */

	public java.util.List<com.floreantpos.model.KitchenTicketItem> getTicketItems () {
			return ticketItems;
	}



	/**
	 * Set the value related to the column: ticketItems
	 * @param ticketItems the ticketItems value
	 */
			public void setTicketItems (java.util.List<com.floreantpos.model.KitchenTicketItem> ticketItems) {
			this.ticketItems = ticketItems;
	}

	public void addToticketItems (com.floreantpos.model.KitchenTicketItem kitchenTicketItem) {
		if (null == getTicketItems()) setTicketItems(new java.util.ArrayList<com.floreantpos.model.KitchenTicketItem>());
		getTicketItems().add(kitchenTicketItem);
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.KitchenTicket)) return false;
		else {
			com.floreantpos.model.KitchenTicket kitchenTicket = (com.floreantpos.model.KitchenTicket) obj;
			if (null == this.getId() || null == kitchenTicket.getId()) return this == obj;
			else return (this.getId().equals(kitchenTicket.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}