package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the MENU_PAGE_ITEM table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="MENU_PAGE_ITEM"
 */

public abstract class BaseMenuPageItem  implements Comparable, Serializable {

	public static String REF = "MenuPageItem"; //$NON-NLS-1$
	public static String PROP_MENU_PAGE_ID = "menuPageId"; //$NON-NLS-1$
	public static String PROP_IMAGE_ID = "imageId"; //$NON-NLS-1$
	public static String PROP_SHOW_IMAGE_ONLY = "showImageOnly"; //$NON-NLS-1$
	public static String PROP_VISIBLE = "visible"; //$NON-NLS-1$
	public static String PROP_SORT_ORDER = "sortOrder"; //$NON-NLS-1$
	public static String PROP_HEIGHT = "height"; //$NON-NLS-1$
	public static String PROP_TEXT_COLOR_CODE = "textColorCode"; //$NON-NLS-1$
	public static String PROP_COL = "col"; //$NON-NLS-1$
	public static String PROP_ROW = "row"; //$NON-NLS-1$
	public static String PROP_BUTTON_COLOR_CODE = "buttonColorCode"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_WIDTH = "width"; //$NON-NLS-1$
	public static String PROP_HAS_VARIANT = "hasVariant"; //$NON-NLS-1$
	public static String PROP_MENU_ITEM_NAME = "menuItemName"; //$NON-NLS-1$
	public static String PROP_TRANSLATED_NAME = "translatedName"; //$NON-NLS-1$
	public static String PROP_VARIANT = "variant"; //$NON-NLS-1$
	public static String PROP_MENU_ITEM_ID = "menuItemId"; //$NON-NLS-1$


	// constructors
	public BaseMenuPageItem () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseMenuPageItem (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	private long version;

	// fields
			private java.lang.Integer col;
				private java.lang.Integer row;
				private java.lang.Integer width;
				private java.lang.Integer height;
				private java.lang.Boolean visible;
				private java.lang.Boolean hasVariant;
				private java.lang.Boolean variant;
				private java.lang.String menuItemId;
				private java.lang.String menuItemName;
				private java.lang.String translatedName;
				private java.lang.Integer sortOrder;
				private java.lang.Integer buttonColorCode;
				private java.lang.Integer textColorCode;
				private java.lang.String imageId;
				private java.lang.Boolean showImageOnly;
				private java.lang.String menuPageId;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: COL
	 */

	public java.lang.Integer getCol () {
						return col == null ? Integer.valueOf(0) : col;
		}



	/**
	 * Set the value related to the column: COL
	 * @param col the COL value
	 */
			public void setCol (java.lang.Integer col) {
			this.col = col;
	}



	/**
	 * Return the value associated with the column: ROW
	 */

	public java.lang.Integer getRow () {
						return row == null ? Integer.valueOf(0) : row;
		}



	/**
	 * Set the value related to the column: ROW
	 * @param row the ROW value
	 */
			public void setRow (java.lang.Integer row) {
			this.row = row;
	}



	/**
	 * Return the value associated with the column: WIDTH
	 */

	public java.lang.Integer getWidth () {
						return width == null ? Integer.valueOf(0) : width;
		}



	/**
	 * Set the value related to the column: WIDTH
	 * @param width the WIDTH value
	 */
			public void setWidth (java.lang.Integer width) {
			this.width = width;
	}



	/**
	 * Return the value associated with the column: HEIGHT
	 */

	public java.lang.Integer getHeight () {
						return height == null ? Integer.valueOf(0) : height;
		}



	/**
	 * Set the value related to the column: HEIGHT
	 * @param height the HEIGHT value
	 */
			public void setHeight (java.lang.Integer height) {
			this.height = height;
	}



	/**
	 * Return the value associated with the column: VISIBLE
	 */

	public java.lang.Boolean isVisible () {
						return visible == null ? Boolean.valueOf(true) : visible;
			}

	public java.lang.Boolean getVisible () {
					return visible == null ? Boolean.valueOf(true) : visible;
			}


	/**
	 * Set the value related to the column: VISIBLE
	 * @param visible the VISIBLE value
	 */
			public void setVisible (java.lang.Boolean visible) {
			this.visible = visible;
	}


	/**
	 * Custom property
	 */
	public static String getVisibleDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: HAS_VARIANT
	 */

	public java.lang.Boolean isHasVariant () {
					return hasVariant == null ? Boolean.FALSE : hasVariant;
		}

	public java.lang.Boolean getHasVariant () {
				return hasVariant == null ? Boolean.FALSE : hasVariant;
			}


	/**
	 * Set the value related to the column: HAS_VARIANT
	 * @param hasVariant the HAS_VARIANT value
	 */
			public void setHasVariant (java.lang.Boolean hasVariant) {
			this.hasVariant = hasVariant;
	}



	/**
	 * Return the value associated with the column: IS_VARIANT
	 */

	public java.lang.Boolean isVariant () {
					return variant == null ? Boolean.FALSE : variant;
		}

	public java.lang.Boolean getVariant () {
				return variant == null ? Boolean.FALSE : variant;
			}


	/**
	 * Set the value related to the column: IS_VARIANT
	 * @param variant the IS_VARIANT value
	 */
			public void setVariant (java.lang.Boolean variant) {
			this.variant = variant;
	}



	/**
	 * Return the value associated with the column: MENU_ITEM_ID
	 */

	public java.lang.String getMenuItemId () {
			return menuItemId;
	}



	/**
	 * Set the value related to the column: MENU_ITEM_ID
	 * @param menuItemId the MENU_ITEM_ID value
	 */
			public void setMenuItemId (java.lang.String menuItemId) {
			this.menuItemId = menuItemId;
	}



	/**
	 * Return the value associated with the column: MENU_ITEM_NAME
	 */

	public java.lang.String getMenuItemName () {
			return menuItemName;
	}



	/**
	 * Set the value related to the column: MENU_ITEM_NAME
	 * @param menuItemName the MENU_ITEM_NAME value
	 */
			public void setMenuItemName (java.lang.String menuItemName) {
			this.menuItemName = menuItemName;
	}



	/**
	 * Return the value associated with the column: TRANSLATED_NAME
	 */

	public java.lang.String getTranslatedName () {
			return translatedName;
	}



	/**
	 * Set the value related to the column: TRANSLATED_NAME
	 * @param translatedName the TRANSLATED_NAME value
	 */
			public void setTranslatedName (java.lang.String translatedName) {
			this.translatedName = translatedName;
	}



	/**
	 * Return the value associated with the column: SORT_ORDER
	 */

	public java.lang.Integer getSortOrder () {
						return sortOrder == null ? Integer.valueOf(0) : sortOrder;
		}



	/**
	 * Set the value related to the column: SORT_ORDER
	 * @param sortOrder the SORT_ORDER value
	 */
			public void setSortOrder (java.lang.Integer sortOrder) {
			this.sortOrder = sortOrder;
	}



	/**
	 * Return the value associated with the column: BTN_COLOR
	 */

	public java.lang.Integer getButtonColorCode () {
						return buttonColorCode == null ? null : buttonColorCode;
			}



	/**
	 * Set the value related to the column: BTN_COLOR
	 * @param buttonColorCode the BTN_COLOR value
	 */
			public void setButtonColorCode (java.lang.Integer buttonColorCode) {
			this.buttonColorCode = buttonColorCode;
	}


	/**
	 * Custom property
	 */
	public static String getButtonColorCodeDefaultValue () {
		return "null";
	}


	/**
	 * Return the value associated with the column: TEXT_COLOR
	 */

	public java.lang.Integer getTextColorCode () {
						return textColorCode == null ? null : textColorCode;
			}



	/**
	 * Set the value related to the column: TEXT_COLOR
	 * @param textColorCode the TEXT_COLOR value
	 */
			public void setTextColorCode (java.lang.Integer textColorCode) {
			this.textColorCode = textColorCode;
	}


	/**
	 * Custom property
	 */
	public static String getTextColorCodeDefaultValue () {
		return "null";
	}


	/**
	 * Return the value associated with the column: IMAGE_ID
	 */

	public java.lang.String getImageId () {
			return imageId;
	}



	/**
	 * Set the value related to the column: IMAGE_ID
	 * @param imageId the IMAGE_ID value
	 */
			public void setImageId (java.lang.String imageId) {
			this.imageId = imageId;
	}



	/**
	 * Return the value associated with the column: SHOW_IMAGE_ONLY
	 */

	public java.lang.Boolean isShowImageOnly () {
					return showImageOnly == null ? Boolean.FALSE : showImageOnly;
		}

	public java.lang.Boolean getShowImageOnly () {
				return showImageOnly == null ? Boolean.FALSE : showImageOnly;
			}


	/**
	 * Set the value related to the column: SHOW_IMAGE_ONLY
	 * @param showImageOnly the SHOW_IMAGE_ONLY value
	 */
			public void setShowImageOnly (java.lang.Boolean showImageOnly) {
			this.showImageOnly = showImageOnly;
	}



	/**
	 * Return the value associated with the column: MENU_PAGE_ID
	 */

	public java.lang.String getMenuPageId () {
			return menuPageId;
	}



	/**
	 * Set the value related to the column: MENU_PAGE_ID
	 * @param menuPageId the MENU_PAGE_ID value
	 */
			public void setMenuPageId (java.lang.String menuPageId) {
			this.menuPageId = menuPageId;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.MenuPageItem)) return false;
		else {
			com.floreantpos.model.MenuPageItem menuPageItem = (com.floreantpos.model.MenuPageItem) obj;
			if (null == this.getId() || null == menuPageItem.getId()) return this == obj;
			else return (this.getId().equals(menuPageItem.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}