package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.MachineResult;
import com.floreantpos.swing.PaginationSupport;

public class MachineResultDAO extends BaseMachineResultDAO {

	public MachineResultDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		Serializable serializable = super.save(obj, s);
		return serializable;
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	public MachineResult getOrderHistoryBySampleId(String sampleId) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(MachineResult.class);
			criteria.add(Restrictions.eqOrIsNull(MachineResult.PROP_SAMPLE_ID, sampleId));
	
			Calendar calendar = Calendar.getInstance();
			Date endOfDay = calendar.getTime();
			calendar.add(Calendar.HOUR_OF_DAY, -24);
			Date startOfDay = calendar.getTime();
			criteria.add(Restrictions.between(MachineResult.PROP_RESULT_DATE, startOfDay, endOfDay));
			criteria.addOrder(Order.desc(MachineResult.PROP_RESULT_DATE));
	
			criteria.setMaxResults(1);
			return (MachineResult) criteria.uniqueResult();
		}
	}

	public void findMachineResults(String sampleId, PaginationSupport tableModel) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(MachineResult.class);

			if (StringUtils.isNotBlank(sampleId)) {
				criteria.add(Restrictions.eq(MachineResult.PROP_SAMPLE_ID, sampleId));
			}
			tableModel.setNumRows(rowCount(criteria));
			criteria.setFirstResult(tableModel.getCurrentRowIndex());
			criteria.setMaxResults(tableModel.getPageSize());
			criteria.addOrder(Order.desc(MachineResult.PROP_RESULT_DATE));
			tableModel.setRows(criteria.list());
		}
	}

}