package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BaseConsentTemplate;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

public class ConsentTemplate extends BaseConsentTemplate implements TimedModel, PropertyContainer2 {
	private static final long serialVersionUID = 1L;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	private transient JsonObject propertiesContainer;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public ConsentTemplate() {
	}

	/**
	 * Constructor for primary key
	 */
	public ConsentTemplate(java.lang.String id) {
		super(id);
	}

	@Override
	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	@Override
	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	@Override
	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	@Override
	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProperties = super.getProperties();
		if (StringUtils.isEmpty(jsonProperties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProperties, JsonObject.class);
		}
		return propertiesContainer;
	}

	public boolean isPrintPadHeader() {
		return getBooleanProperty("is_print_pad_header", false);
	}

	public void putPrintPadHeader(boolean isPrintPadHeader) {
		addProperty("is_print_pad_header", String.valueOf(isPrintPadHeader));
	}

	public boolean isPrintStoreLogo() {
		return getBooleanProperty("print_store_logo", false);
	}

	public void putPrintStoreLogo(boolean isPrintStoreLogo) {
		addProperty("print_store_logo", String.valueOf(isPrintStoreLogo));
	}

	public String getReportFooterMargin() {
		return getProperty("report_footer_margin");
	}

	public void putReportFooterMargin(String footerMargin) {
		addProperty("report_footer_margin", footerMargin);
	}

	public String getReportHeaderMargin() {
		return getProperty("report_header_margin");
	}

	public void putReportHeaderMargin(String headerMargin) {
		addProperty("report_header_margin", headerMargin);
	}
}