package com.floreantpos.model;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.Messages;
import com.floreantpos.model.base.BasePriceShift;
import com.floreantpos.util.ShiftUtil;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "dayOfWeekAsString", "formattedStartTime", "formattedEndTime" })
@XmlRootElement
public class PriceShift extends BasePriceShift {
	private static final long serialVersionUID = 1L;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public PriceShift() {
	}

	/**
	 * Constructor for primary key
	 */
	public PriceShift(java.lang.String id, java.lang.String outletId) {
		super(id, outletId);
	}

	/**
	 * Constructor for required fields
	 */
	public PriceShift(java.lang.String id, java.lang.String outletId, java.lang.String name) {

		super(id, outletId, name);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public boolean equals(Object obj) {
		if (!(obj instanceof PriceShift))
			return false;

		return getName().equalsIgnoreCase(((PriceShift) obj).getName());
	}

	@Override
	public String toString() {
		return getName();
	}

	private String dayOfWeekAsString;

	public String getDayOfWeekAsString() {
		String daysDisplay = ""; //$NON-NLS-1$
		String daysString = getDaysOfWeek();
		if (StringUtils.isNotEmpty(daysString)) {
			String[] split = daysString.split(","); //$NON-NLS-1$
			if (split.length == 7)
				return Messages.getString("PriceShift.2"); //$NON-NLS-1$
			if (split.length > 0) {
				for (int i = 0; i < split.length; i++) {
					int day = Integer.valueOf(split[i]);
					DayOfWeek week = DayOfWeek.getDayOfWeek(day);
					daysDisplay += week.name();
					if (i != split.length - 1) {
						daysDisplay += ","; //$NON-NLS-1$
					}
				}
			}
		}
		return daysDisplay;
	}

	public void setDayOfWeekAsString(String dayOfWeekAsString) {
		this.dayOfWeekAsString = dayOfWeekAsString;
	}

	public boolean isAnyDay() {
		String daysString = getDaysOfWeek();
		if (daysString != null) {
			String[] split = daysString.split(","); //$NON-NLS-1$
			if (split.length == 7) {
				return true;
			}
		}
		return false;
	}

	public void setAnyDay(boolean selected) {
		if (selected) {
			setDaysOfWeek("1,2,3,4,5,6,7"); //$NON-NLS-1$
		}
	}

	@XmlTransient
	public String getFormattedStartTime() {
		return ShiftUtil.buildShiftTimeRepresentation(getStartTime()); //$NON-NLS-1$
	}

	public void setFormattedStartTime(String formattedStartTime) {

	}

	@XmlTransient
	public String getFormattedEndTime() {
		return ShiftUtil.buildShiftTimeRepresentation(getEndTime());
	}

	public void setFormattedEndTime(String formattedEndTime) {

	}
}