package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosLog;
import com.floreantpos.model.Consent;
import com.floreantpos.model.ConsentType;
import com.floreantpos.swing.PaginatedListModel;

public class ConsentDAO extends BaseConsentDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public ConsentDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	@Override
	public void delete(Object obj, Session s) throws HibernateException {
		Consent consents = (Consent) obj;
		consents.setDeleted(true);
		update(consents, s);
	}

	public void findAll(ConsentType consentType, String patientId, PaginatedListModel<Consent> dataModel, String outletId) {
		try (Session session = this.createNewSession()) {
			Criteria criteria = session.createCriteria(Consent.class);
			this.addDeletedFilter(criteria);
			if (StringUtils.isNotBlank(outletId)) {
				criteria.add(Restrictions.eq(Consent.PROP_OUTLET_ID, outletId));
			}
			if (StringUtils.isNotBlank(patientId)) {
				criteria.add(Restrictions.eq(Consent.PROP_PATIENT_ID, patientId));
			}
			criteria.add(Restrictions.eq(Consent.PROP_CONSENT_TYPE, consentType.name()).ignoreCase());

			dataModel.setNumRows(rowCount(criteria));

			criteria.setFirstResult(dataModel.getCurrentRowIndex());
			criteria.setMaxResults(dataModel.getPageSize());

			criteria.addOrder(Order.desc(Consent.PROP_CREATE_DATE));
			List<Consent> list = criteria.list();

			dataModel.setData(list);
		} catch (Exception e) {
			PosLog.error(getClass(), e);
		}
	}
}