package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.Date;

import org.hibernate.EmptyInterceptor;
import org.hibernate.type.Type;

import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TimedModel;

public class PosDataInterceptor extends EmptyInterceptor {
	@Override
	public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
		if (entity instanceof TicketItem || entity instanceof TimedModel) {
			return false;
		}
		try {
			int indexOf = getUpdateTimePropIndex(propertyNames);
			if (indexOf != -1) {
				currentState[indexOf] = new Date();
			}
			return true;
		} catch (Exception e) {
//			PosLog.error(getClass(), e);
		}
		return false;
	}
	
	@Override
	public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
		if (entity instanceof TicketItem || entity instanceof TimedModel) {
			return false;
		}
		try {
			int indexOf = getUpdateTimePropIndex(propertyNames);
			if (indexOf != -1) {
				state[indexOf] = new Date();
			}
			return true;
		} catch (Exception e) {
//			PosLog.error(getClass(), e);
		}
		return false;
	}
	
	private int getUpdateTimePropIndex(String[] properties) {
		for (int i = 0; i < properties.length; i++) {
			if (Ticket.PROP_LAST_UPDATE_TIME.equals(properties[i])) {
				return i;
			}
		}
		return -1;
	}
}
