package com.floreantpos.model.ext;

public enum ReciptPaperSize {
	FiftyEight("58mm"), SeventySix("76mm"), Eighty("80mm");

	private String displayString;

	private ReciptPaperSize(String displayString) {
		this.displayString = displayString;
	}

	public String getReportNameAccording2Size(String reportName) {
		return reportName + "-" + displayString; //$NON-NLS-1$
	}

	public static ReciptPaperSize fromName(String name) {
		try {
			return valueOf(name);
		} catch (Exception e) {
			return ReciptPaperSize.Eighty;
		}
	}

	@Override
	public String toString() {
		return displayString;
	}
}
