package com.floreantpos.util;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Date;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;

import com.floreantpos.model.Quotation;
import com.floreantpos.model.SequenceNumber;
import com.floreantpos.model.dao.QuotationDAO;
import com.floreantpos.model.dao.SequenceNumberDAO;

public class QuotationIdGenerator extends GlobalIdGenerator {

	@Override
	public Serializable generate(SessionImplementor session, Object object) throws HibernateException {
		Class<? extends Object> clazz = object.getClass();
		Serializable generatedId = null;
		try {
			Method method = clazz.getMethod("getId", (Class<?>[]) null); //$NON-NLS-1$
			if (method != null) {
				Object id = method.invoke(object, (Object[]) null);
				if (id != null) {
					generatedId = (Serializable) id;
				}
			}

		} catch (Exception e) {
		}
		if (generatedId == null && object instanceof Quotation) {
			Quotation quotation = (Quotation) object;
			generatedId = generateOrderId((Session) session, quotation.getCreateDate());
		}
		else {
			generatedId = super.generateGlobalId();
		}
		return generatedId;
	}

	public static String generateQuotationId(Quotation quotation) {
		try (Session session = QuotationDAO.getInstance().createNewSession()) {
			return generateOrderId(session, quotation.getCreateDate());
		}
	}

	private static String generateOrderId(Session session, Date createDate) {

		if (createDate == null) {
			createDate = new Date();
		}

		String prefix = "Q" + SequenceNumber.yearMonthDayFormat.format(createDate); //$NON-NLS-1$

		String id = prefix + SequenceNumber.threeDigitDecimalFormat
				.format(SequenceNumberDAO.getInstance().getNextSequenceNumber(SequenceNumber.QUOTATION_SEQUENCE_NUMBER, prefix));

		while (QuotationDAO.getInstance().get(id, session) != null) {
			id = prefix + SequenceNumber.threeDigitDecimalFormat
					.format(SequenceNumberDAO.getInstance().getNextSequenceNumber(SequenceNumber.QUOTATION_SEQUENCE_NUMBER, prefix));
		}

		return id;
	}

}
