/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.db.update;

import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

import com.floreantpos.PosLog;

public class UpdateDBTo372 {

	private SessionFactory sessionFactory;
	private String schemaName;

	public UpdateDBTo372(SessionFactory sessionFactory, String schemaName) {
		this.sessionFactory = sessionFactory;
		this.schemaName = schemaName;
	}

	public void updateTicketType() {
		PosLog.info(getClass(), "Updating " + schemaName + " schema."); //$NON-NLS-1$
		try (Session session = sessionFactory.openSession()) {
			Transaction transaction = session.beginTransaction();
			SQLQuery sqlQuery = session.createSQLQuery(
					"update " + schemaName + ".transactions tr set ticket_type = (select type from " + schemaName + ".ticket t where t.id=tr.ticket_id)"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			PosLog.info(getClass(), "updated query: " + sqlQuery + ""); //$NON-NLS-1$ //$NON-NLS-2$
			int update = sqlQuery.executeUpdate();
			PosLog.info(getClass(), "updated " + update + " transactions"); //$NON-NLS-1$ //$NON-NLS-2$
			transaction.commit();
		}

	}

}