package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the SHIFT table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="SHIFT"
 */

public abstract class BaseShift  implements Comparable, Serializable {

	public static String REF = "Shift"; //$NON-NLS-1$
	public static String PROP_DAYS_OF_WEEK = "daysOfWeek"; //$NON-NLS-1$
	public static String PROP_DESCRIPTION = "description"; //$NON-NLS-1$
	public static String PROP_SHIFT_LENGTH = "shiftLength"; //$NON-NLS-1$
	public static String PROP_START_HOUR = "startHour"; //$NON-NLS-1$
	public static String PROP_START_MIN = "startMin"; //$NON-NLS-1$
	public static String PROP_PRIORITY = "priority"; //$NON-NLS-1$
	public static String PROP_END_MIN = "endMin"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_END_HOUR = "endHour"; //$NON-NLS-1$
	public static String PROP_ENABLE = "enable"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$


	// constructors
	public BaseShift () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseShift (
		java.lang.String id,
		java.lang.String outletId) {

		this.setId(id);
		this.setOutletId(outletId);
		initialize();
	}

	/**
	 * Constructor for required fields
	 */
	public BaseShift (
		java.lang.String id,
		java.lang.String outletId,
		java.lang.String name) {

		this.setId(id);
		this.setOutletId(outletId);
		this.setName(name);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key

	private java.lang.String id;

	private java.lang.String outletId;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String name;
				private java.lang.String description;
				private java.lang.Integer startHour;
				private java.lang.Integer startMin;
				private java.lang.Integer endHour;
				private java.lang.Integer endMin;
				private java.lang.String daysOfWeek;
				private java.lang.Long shiftLength;
				private java.lang.Integer priority;
				private java.lang.String properties;
				private java.lang.Boolean enable;
				private java.lang.Boolean deleted;
	


	/**
     * @hibernate.property
     *  column=ID
	 * not-null=true
	 */
	public java.lang.String getId () {
		return this.id;
	}

	/**
	 * Set the value related to the column: ID
	 * @param id the ID value
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}

	/**
     * @hibernate.property
     *  column=OUTLET_ID
	 * not-null=true
	 */
	public java.lang.String getOutletId () {
		return this.outletId;
	}

	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
	public void setOutletId (java.lang.String outletId) {
		this.outletId = outletId;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: DESCRIPTION
	 */

	public java.lang.String getDescription () {
			return description;
	}



	/**
	 * Set the value related to the column: DESCRIPTION
	 * @param description the DESCRIPTION value
	 */
			public void setDescription (java.lang.String description) {
			this.description = description;
	}



	/**
	 * Return the value associated with the column: START_HOUR
	 */

	public java.lang.Integer getStartHour () {
						return startHour == null ? Integer.valueOf(0) : startHour;
		}



	/**
	 * Set the value related to the column: START_HOUR
	 * @param startHour the START_HOUR value
	 */
			public void setStartHour (java.lang.Integer startHour) {
			this.startHour = startHour;
	}



	/**
	 * Return the value associated with the column: START_MIN
	 */

	public java.lang.Integer getStartMin () {
						return startMin == null ? Integer.valueOf(0) : startMin;
		}



	/**
	 * Set the value related to the column: START_MIN
	 * @param startMin the START_MIN value
	 */
			public void setStartMin (java.lang.Integer startMin) {
			this.startMin = startMin;
	}



	/**
	 * Return the value associated with the column: END_HOUR
	 */

	public java.lang.Integer getEndHour () {
						return endHour == null ? Integer.valueOf(0) : endHour;
		}



	/**
	 * Set the value related to the column: END_HOUR
	 * @param endHour the END_HOUR value
	 */
			public void setEndHour (java.lang.Integer endHour) {
			this.endHour = endHour;
	}



	/**
	 * Return the value associated with the column: END_MIN
	 */

	public java.lang.Integer getEndMin () {
						return endMin == null ? Integer.valueOf(0) : endMin;
		}



	/**
	 * Set the value related to the column: END_MIN
	 * @param endMin the END_MIN value
	 */
			public void setEndMin (java.lang.Integer endMin) {
			this.endMin = endMin;
	}



	/**
	 * Return the value associated with the column: DAYS_OF_WEEK
	 */

	public java.lang.String getDaysOfWeek () {
			return daysOfWeek;
	}



	/**
	 * Set the value related to the column: DAYS_OF_WEEK
	 * @param daysOfWeek the DAYS_OF_WEEK value
	 */
			public void setDaysOfWeek (java.lang.String daysOfWeek) {
			this.daysOfWeek = daysOfWeek;
	}



	/**
	 * Return the value associated with the column: SHIFT_LEN
	 */

	public java.lang.Long getShiftLength () {
			return shiftLength;
	}



	/**
	 * Set the value related to the column: SHIFT_LEN
	 * @param shiftLength the SHIFT_LEN value
	 */
			public void setShiftLength (java.lang.Long shiftLength) {
			this.shiftLength = shiftLength;
	}



	/**
	 * Return the value associated with the column: PRIORITY
	 */

	public java.lang.Integer getPriority () {
						return priority == null ? Integer.valueOf(0) : priority;
		}



	/**
	 * Set the value related to the column: PRIORITY
	 * @param priority the PRIORITY value
	 */
			public void setPriority (java.lang.Integer priority) {
			this.priority = priority;
	}


	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: ENABLE
	 */

	public java.lang.Boolean isEnable () {
						return enable == null ? Boolean.valueOf(true) : enable;
			}

	public java.lang.Boolean getEnable () {
					return enable == null ? Boolean.valueOf(true) : enable;
			}


	/**
	 * Set the value related to the column: ENABLE
	 * @param enable the ENABLE value
	 */
			public void setEnable (java.lang.Boolean enable) {
			this.enable = enable;
	}


	/**
	 * Custom property
	 */
	public static String getEnableDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;//abcd
		if (!(obj instanceof com.floreantpos.model.Shift)) return false;
		else {
			com.floreantpos.model.Shift shift = (com.floreantpos.model.Shift) obj;
			if (null != this.getId() && null != shift.getId()) {
				if (!this.getId().equals(shift.getId())) {
					return false;
				}
			}
			else {
				return false;
			}
			if (null != this.getOutletId() && null != shift.getOutletId()) {
				if (!this.getOutletId().equals(shift.getOutletId())) {
					return false;
				}
			}
			else {
				return false;
			}
			return true;
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			StringBuilder sb = new StringBuilder();
			if (null != this.getId()) {
				sb.append(this.getId().hashCode());
				sb.append(":");
			}
			else {
				return super.hashCode();
			}
			if (null != this.getOutletId()) {
				sb.append(this.getOutletId().hashCode());
				sb.append(":");
			}
			else {
				return super.hashCode();
			}
			this.hashCode = sb.toString().hashCode();
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}